/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.steps;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.util.DecompileUtils;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.runtime.steps.IStep;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class DecompileStep
implements IStep {
    @Override
    public TaskProvider<? extends Runtime> buildTask(VanillaRuntimeDefinition definition, TaskProvider<? extends WithOutput> inputProvidingTask, @NotNull File minecraftCache, @NotNull File workingDirectory, @NotNull Map<String, TaskProvider<? extends WithOutput>> pipelineTasks, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactTasks, @NotNull Consumer<TaskProvider<? extends Runtime>> additionalTaskConfigurator) {
        return ((VanillaRuntimeSpecification)definition.getSpecification()).getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Definition)definition, (String)"decompile"), DefaultExecute.class, task -> {
            task.getExecutingClasspath().from(new Object[]{ToolUtilities.resolveTool((Project)task.getProject(), Tools::getDecompiler)});
            task.getJvmArguments().addAll((Iterable)DecompileUtils.DEFAULT_JVM_ARGS);
            task.getProgramArguments().addAll((Iterable)DecompileUtils.DEFAULT_PROGRAMM_ARGS);
            CommonRuntimeUtils.buildArguments((RuntimeArguments)task.getArguments(), (Definition)definition, (Map)DecompileUtils.DEFAULT_DECOMPILE_VALUES, (Map)pipelineTasks, (Runtime)task, Optional.of(inputProvidingTask));
        });
    }

    @Override
    public String getName() {
        return "decompile";
    }
}

