/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.util.ServerLaunchInformation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class VanillaRuntimeDefinition
extends CommonRuntimeDefinition<VanillaRuntimeSpecification> {
    private final TaskProvider<DownloadAssets> assetsTaskProvider;
    private final TaskProvider<ExtractNatives> nativesTaskProvider;
    private final Optional<ServerLaunchInformation> serverLaunchInformation;

    public VanillaRuntimeDefinition(@NotNull VanillaRuntimeSpecification specification, @NotNull LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs, @NotNull TaskProvider<? extends ArtifactFromOutput> sourceJarTask, @NotNull TaskProvider<? extends ArtifactFromOutput> rawJarTask, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks, @NotNull Configuration minecraftDependenciesConfiguration, @NotNull Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer, Provider<VersionJson> versionJson, TaskProvider<DownloadAssets> assetsTaskProvider, TaskProvider<ExtractNatives> nativesTaskProvider, Optional<ServerLaunchInformation> serverLaunchInformation) {
        super((CommonRuntimeSpecification)specification, taskOutputs, sourceJarTask, rawJarTask, gameArtifactProvidingTasks, minecraftDependenciesConfiguration, associatedTaskConsumer, versionJson);
        this.assetsTaskProvider = assetsTaskProvider;
        this.nativesTaskProvider = nativesTaskProvider;
        this.serverLaunchInformation = serverLaunchInformation;
    }

    @NotNull
    public TaskProvider<DownloadAssets> getAssets() {
        return this.assetsTaskProvider;
    }

    @NotNull
    public TaskProvider<ExtractNatives> getNatives() {
        return this.nativesTaskProvider;
    }

    @NotNull
    public TaskProvider<? extends WithOutput> getListLibrariesTaskProvider() {
        return this.getTask("libraries");
    }

    public Optional<ServerLaunchInformation> getServerLaunchInformation() {
        return this.serverLaunchInformation;
    }

    protected void buildRunInterpolationData(RunImpl run, MapProperty<String, String> interpolationData) {
        String runtimeVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        interpolationData.put((Object)"version_name", (Object)((VanillaRuntimeSpecification)this.getSpecification()).getMinecraftVersion());
        interpolationData.put((Object)"assets_root", DownloadAssets.getAssetsDirectory((Project)run.getProject()).map(Directory::getAsFile).map(File::getAbsolutePath));
        interpolationData.put((Object)"assets_index_name", this.getAssets().flatMap(DownloadAssets::getAssetIndexFile).map(RegularFile::getAsFile).map(File::getName).map(s -> s.substring(0, s.lastIndexOf(46))));
        interpolationData.put((Object)"auth_access_token", (Object)"0");
        interpolationData.put((Object)"user_type", (Object)"legacy");
        interpolationData.put((Object)"version_type", this.getVersionJson().map(VersionJson::getType));
        interpolationData.put((Object)"natives_directory", this.getNatives().flatMap(OutputSpecification::getOutputDirectory).map(Directory::getAsFile).map(File::getAbsolutePath));
        interpolationData.put((Object)"launcher_name", (Object)"NeoGradle-Vanilla");
        interpolationData.put((Object)"launcher_version", (Object)(runtimeVersion == null ? "DEV" : runtimeVersion));
    }

    public void configureRun(RunImpl run) {
        if (((VanillaRuntimeSpecification)this.getSpecification()).getDistribution().isClient()) {
            run.getArguments().addAll(this.getVersionJson().map(VersionJson::getArguments).map(VersionJson.Arguments::getGame).map(Arrays::stream).map(stream -> stream.filter(VersionJson.RuledObject::isAllowed).flatMap(arg -> arg.value.stream()).collect(Collectors.toList())));
            run.getJvmArguments().addAll(this.getVersionJson().map(VersionJson::getArguments).map(VersionJson.Arguments::getJvm).map(Arrays::stream).map(stream -> stream.filter(VersionJson.RuledObject::isAllowed).flatMap(arg -> arg.value.stream()).collect(Collectors.toList())));
            run.getMainClass().set(this.getVersionJson().map(VersionJson::getMainClass));
            run.getIsClient().set((Object)true);
            run.getIsSingleInstance().set((Object)false);
            MapProperty interpolationData = run.getProject().getObjects().mapProperty(String.class, String.class);
            this.buildRunInterpolationData(run, (MapProperty<String, String>)interpolationData);
            interpolationData.put((Object)"game_directory", (Object)((Directory)run.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
            run.overrideJvmArguments(this.interpolate(run.getJvmArguments(), interpolationData, "$"));
            run.overrideArguments(this.interpolate(run.getArguments(), interpolationData, "$"));
            run.overrideEnvironmentVariables(this.interpolate(run.getEnvironmentVariables(), interpolationData, "$"));
            run.overrideSystemProperties(this.interpolate(run.getSystemProperties(), interpolationData, "$"));
        } else if (((VanillaRuntimeSpecification)this.getSpecification()).getDistribution().isServer()) {
            ServerLaunchInformation launchInformation = this.getServerLaunchInformation().orElseThrow(() -> new IllegalStateException("Server launch information not present for server distribution"));
            run.getMainClass().set(launchInformation.getMainClass());
            run.getIsClient().set((Object)false);
            run.getIsSingleInstance().set((Object)true);
        }
    }
}

