/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.spec;

import com.google.common.collect.Multimap;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.vanilla.runtime.spec.VanillaSpecification;
import net.neoforged.gradle.vanilla.runtime.extensions.VanillaRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public final class VanillaRuntimeSpecification
extends CommonRuntimeSpecification
implements VanillaSpecification {
    private final String minecraftVersion;

    public VanillaRuntimeSpecification(Project project, String name, String version, DistributionType side, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, String minecraftVersion) {
        super(project, name, version, side, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, VanillaRuntimeExtension.class);
        this.minecraftVersion = minecraftVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VanillaRuntimeSpecification)) {
            return false;
        }
        VanillaRuntimeSpecification that = (VanillaRuntimeSpecification)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.getMinecraftVersion(), that.getMinecraftVersion());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMinecraftVersion());
    }

    public String toString() {
        return "VanillaRuntimeSpecification{minecraftVersion='" + this.minecraftVersion + "'}";
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<VanillaRuntimeSpecification, Builder> {
        private Provider<String> minecraftArtifact;
        private Provider<String> minecraftVersion;

        public static Builder from(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            super(project);
            this.withMinecraftArtifact("client");
            this.withDistributionType(DistributionType.CLIENT);
        }

        protected Builder getThis() {
            return this;
        }

        public Builder withMinecraftArtifact(Provider<String> minecraftArtifact) {
            this.minecraftArtifact = minecraftArtifact;
            return this.getThis();
        }

        public Builder withMinecraftArtifact(String minecraftArtifact) {
            if (minecraftArtifact == null) {
                return this.getThis();
            }
            return this.withMinecraftArtifact((Provider<String>)this.project.provider(() -> minecraftArtifact));
        }

        public Builder withMinecraftVersion(Provider<String> minecraftVersion) {
            this.minecraftVersion = minecraftVersion;
            return this.getThis();
        }

        public Builder withMinecraftVersion(String minecraftVersion) {
            if (minecraftVersion == null) {
                return this.getThis();
            }
            return this.withMinecraftVersion((Provider<String>)this.project.provider(() -> minecraftVersion));
        }

        @NotNull
        public VanillaRuntimeSpecification build() {
            return new VanillaRuntimeSpecification(this.project, (String)this.minecraftArtifact.get(), Optional.of((String)this.minecraftVersion.get()).map(v -> v.equals("+") ? "" : v).get(), (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, (String)this.minecraftVersion.get());
        }
    }
}

