/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.dependency;

import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Optional;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementHandler;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementResult;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.extensions.VanillaRuntimeExtension;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.provider.Provider;

public final class VanillaDependencyManager {
    private static final VanillaDependencyManager INSTANCE = new VanillaDependencyManager();

    private VanillaDependencyManager() {
    }

    public static VanillaDependencyManager getInstance() {
        return INSTANCE;
    }

    public void apply(final Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("vanilla", (Action)new Action<DependencyReplacementHandler>(){

            public void execute(DependencyReplacementHandler dependencyReplacementHandler) {
                dependencyReplacementHandler.getReplacer().set(context -> {
                    if (VanillaDependencyManager.this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                        return Optional.empty();
                    }
                    if (!(context.getDependency() instanceof ExternalModuleDependency)) {
                        return Optional.empty();
                    }
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)context.getDependency();
                    VanillaRuntimeDefinition runtimeDefinition = VanillaDependencyManager.buildVanillaRuntimeDefinition(project, context.getProject(), externalModuleDependency);
                    return Optional.of(new DependencyReplacementResult(project, Optional.of(ConfigurationUtils.findReplacementConfigurations((Project)project, (Configuration)context.getConfiguration())), name -> CommonRuntimeUtils.buildTaskName((Definition)runtimeDefinition, (String)name), runtimeDefinition.getSourceJarTask(), runtimeDefinition.getRawJarTask(), runtimeDefinition.getMinecraftDependenciesConfiguration(), builder -> builder.setVersion(((VanillaRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion()), builder -> builder.setVersion(((VanillaRuntimeSpecification)runtimeDefinition.getSpecification()).getMinecraftVersion()), arg_0 -> ((VanillaRuntimeDefinition)runtimeDefinition).setReplacedDependency(arg_0), arg_0 -> ((VanillaRuntimeDefinition)runtimeDefinition).onRepoWritten(arg_0), Sets::newHashSet));
                });
            }
        });
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return !"net.minecraft".equals(externalModuleDependency.getGroup()) || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("client") || dependency.getName().equals("server");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return VanillaDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return "sources".equals(artifact.getClassifier()) && "jar".equals(artifact.getExtension());
    }

    private static VanillaRuntimeDefinition buildVanillaRuntimeDefinition(Project project, Project configureProject, ExternalModuleDependency dependency) {
        VanillaRuntimeExtension runtimeExtension = (VanillaRuntimeExtension)((Object)project.getExtensions().getByType(VanillaRuntimeExtension.class));
        return (VanillaRuntimeDefinition)runtimeExtension.maybeCreate(builder -> {
            String version = dependency.getVersion() == null ? (String)runtimeExtension.getVersion().get() : dependency.getVersion();
            builder.withMinecraftArtifact(StringCapitalizationUtils.deCapitalize((String)dependency.getName()));
            builder.withDistributionType(DistributionType.valueOf((String)dependency.getName().toUpperCase(Locale.ROOT)));
            builder.withMinecraftVersion(version);
            builder.withFartVersion((Provider<String>)runtimeExtension.getFartVersion());
            builder.withForgeFlowerVersion((Provider<String>)runtimeExtension.getVineFlowerVersion());
            builder.withAccessTransformerApplierVersion((Provider<String>)runtimeExtension.getAccessTransformerApplierVersion());
        });
    }
}

