/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.util.ServerLaunchInformation;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class VanillaRuntimeDefinition
extends CommonRuntimeDefinition<VanillaRuntimeSpecification> {
    private final TaskProvider<DownloadAssets> assetsTaskProvider;
    private final TaskProvider<ExtractNatives> nativesTaskProvider;
    private final Optional<ServerLaunchInformation> serverLaunchInformation;

    public VanillaRuntimeDefinition(@NotNull VanillaRuntimeSpecification specification, @NotNull LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs, @NotNull TaskProvider<? extends ArtifactProvider> sourceJarTask, @NotNull TaskProvider<? extends ArtifactProvider> rawJarTask, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks, @NotNull Configuration minecraftDependenciesConfiguration, @NotNull Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer, VersionJson versionJson, TaskProvider<DownloadAssets> assetsTaskProvider, TaskProvider<ExtractNatives> nativesTaskProvider, Optional<ServerLaunchInformation> serverLaunchInformation) {
        super((CommonRuntimeSpecification)specification, taskOutputs, sourceJarTask, rawJarTask, gameArtifactProvidingTasks, minecraftDependenciesConfiguration, associatedTaskConsumer, versionJson);
        this.assetsTaskProvider = assetsTaskProvider;
        this.nativesTaskProvider = nativesTaskProvider;
        this.serverLaunchInformation = serverLaunchInformation;
    }

    @NotNull
    public TaskProvider<DownloadAssets> getAssets() {
        return this.assetsTaskProvider;
    }

    @NotNull
    public TaskProvider<ExtractNatives> getNatives() {
        return this.nativesTaskProvider;
    }

    @NotNull
    public TaskProvider<? extends WithOutput> getListLibrariesTaskProvider() {
        return this.getTask("libraries");
    }

    public Optional<ServerLaunchInformation> getServerLaunchInformation() {
        return this.serverLaunchInformation;
    }

    protected Map<String, String> buildRunInterpolationData() {
        HashMap interpolationData = Maps.newHashMap();
        String fgVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        interpolationData.put("version_name", ((VanillaRuntimeSpecification)this.getSpecification()).getMinecraftVersion());
        interpolationData.put("assets_root", ((Directory)((DownloadAssets)this.getAssets().get()).getOutputDirectory().get()).getAsFile().getAbsolutePath());
        interpolationData.put("assets_index_name", ((RegularFile)((DownloadAssets)this.getAssets().get()).getAssetIndexFile().get()).getAsFile().getName().substring(0, ((RegularFile)((DownloadAssets)this.getAssets().get()).getAssetIndexFile().get()).getAsFile().getName().lastIndexOf(46)));
        interpolationData.put("auth_access_token", "0");
        interpolationData.put("user_type", "legacy");
        interpolationData.put("version_type", this.getVersionJson().getType());
        interpolationData.put("natives_directory", ((Directory)((ExtractNatives)this.getNatives().get()).getOutputDirectory().get()).getAsFile().getAbsolutePath());
        interpolationData.put("launcher_name", "NeoGradle-Vanilla");
        interpolationData.put("launcher_version", fgVersion == null ? "DEV" : fgVersion);
        return interpolationData;
    }

    public void configureRun(RunImpl run) {
        if (((VanillaRuntimeSpecification)this.getSpecification()).getDistribution().isClient()) {
            Arrays.stream(this.getVersionJson().getArguments().getGame()).filter(arg -> arg.getRules() == null || arg.getRules().length == 0).flatMap(arg -> arg.value.stream()).forEach(arg -> run.getProgramArguments().add(arg));
            Arrays.stream(this.getVersionJson().getArguments().getJvm()).filter(VersionJson.RuledObject::isAllowed).flatMap(arg -> arg.value.stream()).forEach(arg -> run.getJvmArguments().add(arg));
            run.getMainClass().set((Object)this.getVersionJson().getMainClass());
            run.getIsClient().set((Object)true);
            run.getIsSingleInstance().set((Object)false);
            HashMap interpolationData = Maps.newHashMap(this.buildRunInterpolationData());
            interpolationData.put("game_directory", ((Directory)run.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
            run.overrideJvmArguments(this.interpolate(run.getJvmArguments(), interpolationData, "$"));
            run.overrideProgramArguments(this.interpolate(run.getProgramArguments(), interpolationData, "$"));
            run.overrideEnvironmentVariables(this.interpolate(run.getEnvironmentVariables(), interpolationData, "$"));
            run.overrideSystemProperties(this.interpolate(run.getSystemProperties(), interpolationData, "$"));
        } else if (((VanillaRuntimeSpecification)this.getSpecification()).getDistribution().isServer()) {
            ServerLaunchInformation launchInformation = this.getServerLaunchInformation().orElseThrow(() -> new IllegalStateException("Server launch information not present for server distribution"));
            run.getMainClass().set((Object)launchInformation.getMainClass());
            run.getIsClient().set((Object)false);
            run.getIsSingleInstance().set((Object)true);
        }
    }
}

