/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.steps;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.runtime.tasks.NoopRuntime;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Parchment;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.runtime.steps.IStep;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class ParchmentStep
implements IStep {
    @Override
    public TaskProvider<? extends Runtime> buildTask(VanillaRuntimeDefinition definition, TaskProvider<? extends WithOutput> inputProvidingTask, @NotNull File minecraftCache, @NotNull File workingDirectory, @NotNull Map<String, TaskProvider<? extends WithOutput>> pipelineTasks, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactTasks, @NotNull Consumer<TaskProvider<? extends Runtime>> additionalTaskConfigurator) {
        TaskProvider<? extends WithOutput> collectLibraryInformationTask = pipelineTasks.get(CommonRuntimeUtils.buildTaskName((Definition)definition, (String)"libraries"));
        return ParchmentStep.maybeApplyParchment(definition, inputProvidingTask, workingDirectory, (Provider<RegularFile>)collectLibraryInformationTask.flatMap(OutputSpecification::getOutput));
    }

    private static TaskProvider<? extends Runtime> maybeApplyParchment(VanillaRuntimeDefinition definition, TaskProvider<? extends WithOutput> inputProvidingTask, File vanillaDirectory, Provider<RegularFile> listLibrariesOutput) {
        Project project = ((VanillaRuntimeSpecification)definition.getSpecification()).getProject();
        Parchment parchment = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getParchment();
        Tools tools = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools();
        if (!((Boolean)parchment.getIsEnabled().get()).booleanValue()) {
            return project.getTasks().register(CommonRuntimeUtils.buildTaskName((Definition)definition, (String)"applyParchmentNoop"), NoopRuntime.class, task -> task.getInput().set(inputProvidingTask.flatMap(OutputSpecification::getOutput)));
        }
        return project.getTasks().register(CommonRuntimeUtils.buildTaskName((Definition)definition, (String)"applyParchment"), DefaultExecute.class, task -> {
            File mappingFile = ToolUtilities.resolveTool((Project)project, (String)((String)parchment.getParchmentArtifact().get()));
            File toolExecutable = ToolUtilities.resolveTool((Project)project, (String)((String)tools.getJST().get()));
            task.getArguments().putFile("mappings", project.provider(() -> mappingFile));
            task.getArguments().putRegularFile("libraries", listLibrariesOutput);
            task.getArguments().putRegularFile("input", inputProvidingTask.flatMap(OutputSpecification::getOutput));
            task.getExecutingJar().set(toolExecutable);
            task.getProgramArguments().add((Object)"--libraries-list");
            task.getProgramArguments().add((Object)"{libraries}");
            task.getProgramArguments().add((Object)"--enable-parchment");
            task.getProgramArguments().add((Object)"--parchment-mappings");
            task.getProgramArguments().add((Object)"{mappings}");
            task.getProgramArguments().add((Object)"--in-format=archive");
            task.getProgramArguments().add((Object)"--out-format=archive");
            task.getProgramArguments().add((Object)"{input}");
            task.getProgramArguments().add((Object)"{output}");
            StringBuilder builder = new StringBuilder();
            definition.getAllDependencies().forEach(f -> {
                if (!builder.isEmpty()) {
                    builder.append(File.pathSeparator);
                }
                builder.append(f.getAbsolutePath());
            });
            task.getProgramArguments().add((Object)("--classpath=" + builder));
            task.dependsOn(new Object[]{inputProvidingTask});
            task.dependsOn(new Object[]{listLibrariesOutput});
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (Map)Maps.newHashMap(), (String)"applyParchment", (Specification)definition.getSpecification(), (File)vanillaDirectory);
        });
    }

    @Override
    public String getName() {
        return "parchment";
    }
}

