/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.dependency;

import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementHandler;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementResult;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.extensions.VanillaRuntimeExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;

public final class VanillaDependencyManager {
    private static final VanillaDependencyManager INSTANCE = new VanillaDependencyManager();

    private VanillaDependencyManager() {
    }

    public static VanillaDependencyManager getInstance() {
        return INSTANCE;
    }

    public void apply(final Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("vanilla", (Action)new Action<DependencyReplacementHandler>(){

            public void execute(DependencyReplacementHandler dependencyReplacementHandler) {
                dependencyReplacementHandler.getReplacer().set(context -> {
                    if (VanillaDependencyManager.this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                        return Optional.empty();
                    }
                    if (!(context.getDependency() instanceof ExternalModuleDependency)) {
                        return Optional.empty();
                    }
                    ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)context.getDependency();
                    VanillaRuntimeDefinition runtimeDefinition = VanillaDependencyManager.buildVanillaRuntimeDefinition(project, externalModuleDependency);
                    return Optional.of(new ReplacementResult(project, runtimeDefinition.getSourceJarTask(), runtimeDefinition.getRawJarTask(), project.getConfigurations().detachedConfiguration(new Dependency[0]), runtimeDefinition.getMinecraftDependenciesConfiguration(), Collections.emptySet()));
                });
            }
        });
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return !"net.minecraft".equals(externalModuleDependency.getGroup()) || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("client") || dependency.getName().equals("server");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return VanillaDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return "sources".equals(artifact.getClassifier()) && "jar".equals(artifact.getExtension());
    }

    private static VanillaRuntimeDefinition buildVanillaRuntimeDefinition(Project project, ExternalModuleDependency dependency) {
        VanillaRuntimeExtension runtimeExtension = (VanillaRuntimeExtension)((Object)project.getExtensions().getByType(VanillaRuntimeExtension.class));
        return (VanillaRuntimeDefinition)runtimeExtension.maybeCreateFor((Dependency)dependency, builder -> {
            String version = dependency.getVersion() == null ? (String)runtimeExtension.getVersion().get() : dependency.getVersion();
            builder.withMinecraftArtifact(StringCapitalizationUtils.deCapitalize((String)dependency.getName()));
            builder.withDistributionType(DistributionType.valueOf((String)dependency.getName().toUpperCase(Locale.ROOT)));
            builder.withMinecraftVersion(version);
        });
    }
}

