/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.tasks;

import java.io.File;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ExtractBundledServerTask
extends DefaultRuntime {
    @TaskAction
    public void run() throws Exception {
        String minecraftVersion = ((String)this.getMinecraftVersion().get()).toString();
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        try (JarFile zipFile = new JarFile((File)this.getInput().getAsFile().get());){
            ZipEntry entry = zipFile.getEntry(String.format("META-INF/versions/%s/server-%s.jar", minecraftVersion, minecraftVersion));
            if (entry == null) {
                FileUtils.copyFile((File)((File)this.getInput().getAsFile().get()), (File)output);
                return;
            }
            InputStream serverStream = zipFile.getInputStream(entry);
            FileUtils.copyInputStreamToFile((InputStream)serverStream, (File)output);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @Input
    public abstract Property<String> getMinecraftVersion();
}

