/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.steps;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.tasks.NoopRuntime;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.runtime.steps.IStep;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class ApplyAccessTransformerStep
implements IStep {
    @Override
    public TaskProvider<? extends Runtime> buildTask(VanillaRuntimeDefinition definition, TaskProvider<? extends WithOutput> inputProvidingTask, @NotNull File minecraftCache, @NotNull File workingDirectory, @NotNull Map<String, TaskProvider<? extends WithOutput>> pipelineTasks, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactTasks, @NotNull Consumer<TaskProvider<? extends Runtime>> additionalTaskConfigurator) {
        Minecraft minecraftExtension = (Minecraft)((VanillaRuntimeSpecification)definition.getSpecification()).getProject().getExtensions().getByType(Minecraft.class);
        AccessTransformers accessTransformerFiles = minecraftExtension.getAccessTransformers();
        if (accessTransformerFiles.getFiles().isEmpty() && (!accessTransformerFiles.getEntries().isPresent() || ((List)accessTransformerFiles.getEntries().get()).isEmpty())) {
            return ((VanillaRuntimeSpecification)definition.getSpecification()).getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)String.format("apply%sAccessTransformer", StringCapitalizationUtils.capitalize((String)"user"))), NoopRuntime.class, task -> {
                task.getInput().set(inputProvidingTask.flatMap(OutputSpecification::getOutput));
                task.dependsOn(new Object[]{inputProvidingTask});
            });
        }
        TaskProvider task2 = CommonRuntimeTaskUtils.createBinaryAccessTransformer((Definition)definition, (String)"user", (File)workingDirectory, additionalTaskConfigurator, (FileTree)accessTransformerFiles.getFiles().getAsFileTree(), (Collection)((Collection)accessTransformerFiles.getEntries().get()));
        task2.configure(t -> {
            t.getInputFile().set(inputProvidingTask.flatMap(OutputSpecification::getOutput));
            t.dependsOn(new Object[]{inputProvidingTask});
        });
        return task2;
    }

    @Override
    public String getName() {
        return "applyAccessTransformer";
    }

    @Override
    public String getTaskName(VanillaRuntimeDefinition definition) {
        return CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)String.format("apply%sAccessTransformer", StringCapitalizationUtils.capitalize((String)"user")));
    }
}

