/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.spec;

import com.google.common.collect.Multimap;
import java.util.Optional;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.vanilla.runtime.spec.VanillaSpecification;
import net.neoforged.gradle.vanilla.runtime.extensions.VanillaRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public final class VanillaRuntimeSpecification
extends CommonRuntimeSpecification
implements VanillaSpecification {
    private final String minecraftVersion;
    private final String fartVersion;
    private final String forgeFlowerVersion;
    private final String accessTransformerApplierVersion;

    public VanillaRuntimeSpecification(Project project, String name, String version, DistributionType side, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, String minecraftVersion, String fartVersion, String forgeFlowerVersion, String accessTransformerApplierVersion) {
        super(project, name, version, side, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, VanillaRuntimeExtension.class);
        this.minecraftVersion = minecraftVersion;
        this.fartVersion = fartVersion;
        this.forgeFlowerVersion = forgeFlowerVersion;
        this.accessTransformerApplierVersion = accessTransformerApplierVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getFartVersion() {
        return this.fartVersion;
    }

    public String getForgeFlowerVersion() {
        return this.forgeFlowerVersion;
    }

    public String getAccessTransformerApplierVersion() {
        return this.accessTransformerApplierVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VanillaRuntimeSpecification)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VanillaRuntimeSpecification that = (VanillaRuntimeSpecification)((Object)o);
        if (!this.minecraftVersion.equals(that.minecraftVersion)) {
            return false;
        }
        if (!this.fartVersion.equals(that.fartVersion)) {
            return false;
        }
        if (!this.forgeFlowerVersion.equals(that.forgeFlowerVersion)) {
            return false;
        }
        return this.accessTransformerApplierVersion.equals(that.accessTransformerApplierVersion);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.minecraftVersion.hashCode();
        result = 31 * result + this.fartVersion.hashCode();
        result = 31 * result + this.forgeFlowerVersion.hashCode();
        result = 31 * result + this.accessTransformerApplierVersion.hashCode();
        return result;
    }

    public String toString() {
        return "VanillaRuntimeSpec{minecraftVersion='" + this.minecraftVersion + '\'' + ", fartVersion='" + this.fartVersion + '\'' + ", forgeFlowerVersion='" + this.forgeFlowerVersion + '\'' + ", accessTransformerApplierVersion='" + this.accessTransformerApplierVersion + '\'' + '}';
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<VanillaRuntimeSpecification, Builder> {
        private Provider<String> minecraftArtifact;
        private Provider<String> minecraftVersion;
        private Provider<String> fartVersion;
        private boolean hasConfiguredFartVersion = false;
        private Provider<String> forgeFlowerVersion;
        private boolean hasConfiguredForgeFlowerVersion = false;
        private Provider<String> accessTransformerApplierVersion;
        private boolean hasConfiguredAccessTransformerApplierVersion = false;

        public static Builder from(Project project) {
            return new Builder(project);
        }

        private Builder(Project project) {
            super(project);
            this.withMinecraftArtifact("client");
            this.withDistributionType(DistributionType.CLIENT);
        }

        protected Builder getThis() {
            return this;
        }

        protected void configureBuilder() {
            super.configureBuilder();
            VanillaRuntimeExtension runtimeExtension = (VanillaRuntimeExtension)((Object)this.getProject().getExtensions().getByType(VanillaRuntimeExtension.class));
            if (!this.hasConfiguredFartVersion) {
                this.fartVersion = runtimeExtension.getFartVersion();
            }
            if (!this.hasConfiguredForgeFlowerVersion) {
                this.forgeFlowerVersion = runtimeExtension.getVineFlowerVersion();
            }
            if (!this.hasConfiguredAccessTransformerApplierVersion) {
                this.accessTransformerApplierVersion = runtimeExtension.getAccessTransformerApplierVersion();
            }
        }

        public Builder withMinecraftArtifact(Provider<String> minecraftArtifact) {
            this.minecraftArtifact = minecraftArtifact;
            return this.getThis();
        }

        public Builder withMinecraftArtifact(String minecraftArtifact) {
            if (minecraftArtifact == null) {
                return this.getThis();
            }
            return this.withMinecraftArtifact((Provider<String>)this.project.provider(() -> minecraftArtifact));
        }

        public Builder withMinecraftVersion(Provider<String> minecraftVersion) {
            this.minecraftVersion = minecraftVersion;
            return this.getThis();
        }

        public Builder withMinecraftVersion(String minecraftVersion) {
            if (minecraftVersion == null) {
                return this.getThis();
            }
            return this.withMinecraftVersion((Provider<String>)this.project.provider(() -> minecraftVersion));
        }

        public Builder withFartVersion(Provider<String> fartVersion) {
            this.fartVersion = fartVersion;
            this.hasConfiguredFartVersion = true;
            return this.getThis();
        }

        public Builder withFartVersion(String fartVersion) {
            if (fartVersion == null) {
                return this.getThis();
            }
            return this.withFartVersion((Provider<String>)this.project.provider(() -> fartVersion));
        }

        public Builder withForgeFlowerVersion(Provider<String> forgeFlowerVersion) {
            this.forgeFlowerVersion = forgeFlowerVersion;
            this.hasConfiguredForgeFlowerVersion = true;
            return this.getThis();
        }

        public Builder withForgeFlowerVersion(String forgeFlowerVersion) {
            if (forgeFlowerVersion == null) {
                return this.getThis();
            }
            return this.withForgeFlowerVersion((Provider<String>)this.project.provider(() -> forgeFlowerVersion));
        }

        public Builder withAccessTransformerApplierVersion(Provider<String> accessTransformerApplierVersion) {
            this.accessTransformerApplierVersion = accessTransformerApplierVersion;
            this.hasConfiguredAccessTransformerApplierVersion = true;
            return this.getThis();
        }

        public Builder withAccessTransformerApplierVersion(String accessTransformerApplierVersion) {
            if (accessTransformerApplierVersion == null) {
                return this.getThis();
            }
            return this.withAccessTransformerApplierVersion((Provider<String>)this.project.provider(() -> accessTransformerApplierVersion));
        }

        @NotNull
        public VanillaRuntimeSpecification build() {
            return new VanillaRuntimeSpecification(this.project, (String)this.minecraftArtifact.get(), Optional.of(this.minecraftVersion.get()).map(v -> v.equals("+") ? "" : v).get(), (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, (String)this.minecraftVersion.get(), (String)this.fartVersion.get(), (String)this.forgeFlowerVersion.get(), (String)this.accessTransformerApplierVersion.get());
        }
    }
}

