/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.steps;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.naming.tasks.ApplyOfficialMappingsToCompiledJar;
import net.neoforged.gradle.common.util.MappingUtils;
import net.neoforged.gradle.common.util.TaskDependencyUtils;
import net.neoforged.gradle.common.util.exceptions.MultipleDefinitionsFoundException;
import net.neoforged.gradle.common.util.exceptions.NoDefinitionsFoundException;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.TaskBuildingContext;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.util.RenameConstants;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.runtime.steps.IStep;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public class RenameStep
implements IStep {
    @Override
    public TaskProvider<? extends Runtime> buildTask(VanillaRuntimeDefinition definition, TaskProvider<? extends WithOutput> inputProvidingTask, @NotNull File minecraftCache, @NotNull File workingDirectory, @NotNull Map<String, TaskProvider<? extends WithOutput>> pipelineTasks, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactTasks, @NotNull Consumer<TaskProvider<? extends Runtime>> additionalTaskConfigurator) {
        Mappings mappingsExtension = (Mappings)((VanillaRuntimeSpecification)definition.getSpecification()).getProject().getExtensions().getByType(Mappings.class);
        HashMap mappingVersionData = Maps.newHashMap();
        mappingVersionData.put("version", ((VanillaRuntimeSpecification)definition.getSpecification()).getMinecraftVersion());
        mappingVersionData.put("minecraft", ((VanillaRuntimeSpecification)definition.getSpecification()).getMinecraftVersion());
        mappingVersionData.putAll((Map)mappingsExtension.getVersion().get());
        TaskProvider<? extends WithOutput> artifact = inputProvidingTask;
        HashSet additionalTasks = Sets.newHashSet();
        TaskBuildingContext context = new TaskBuildingContext(((VanillaRuntimeSpecification)definition.getSpecification()).getProject(), "mapGame", taskName -> CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)taskName), artifact, definition.getGameArtifactProvidingTasks(), (Map)mappingVersionData, (Set)additionalTasks, (Definition)definition);
        TaskProvider<? extends Runtime> namingTask = this.buildApplyCompiledMappingsTask(context);
        additionalTasks.forEach(additionalTaskConfigurator);
        namingTask.configure(task -> {
            CommonRuntimeUtils.buildArguments((RuntimeArguments)task.getArguments(), (Definition)definition, (Map)RenameConstants.DEFAULT_RENAME_VALUES, (Map)pipelineTasks, (Runtime)task, Optional.of(artifact));
            task.getOutput().set(task.getOutputDirectory().file("output.jar"));
        });
        return namingTask;
    }

    @NotNull
    private TaskProvider<? extends Runtime> buildApplyCompiledMappingsTask(@NotNull TaskBuildingContext context) {
        String ApplyTaskName = CommonRuntimeUtils.buildTaskName((TaskProvider)context.getInputTask(), (String)"deobfuscate");
        if (!context.getRuntimeDefinition().isPresent()) {
            throw new IllegalArgumentException("Cannot apply compiled mappings without a runtime definition");
        }
        TaskProvider librariesTask = context.getLibrariesTask();
        if (librariesTask == null) {
            throw new IllegalArgumentException("Cannot apply compiled mappings without a libraries task");
        }
        TaskProvider applyTask = context.getProject().getTasks().register(ApplyTaskName, ApplyOfficialMappingsToCompiledJar.class, task -> {
            task.setGroup("mappings/official");
            task.setDescription("Unapplies the Official mappings and re-obfuscates a compiled jar");
            task.getMinecraftVersion().set(context.getMappingVersion().flatMap(versionData -> {
                if (versionData.containsKey("version") || versionData.containsKey("minecraft")) {
                    return context.getProject().provider(() -> CacheableMinecraftVersion.from((String)MappingUtils.getVersionOrMinecraftVersion((Map)versionData), (Project)context.getProject()).getFull());
                }
                return context.getInputTask().map(t -> {
                    try {
                        return CacheableMinecraftVersion.from((String)MappingUtils.getVersionOrMinecraftVersion((Map)TaskDependencyUtils.extractRuntimeDefinition((Project)context.getProject(), (Task)t).getMappingVersionData()), (Project)context.getProject()).getFull();
                    }
                    catch (MultipleDefinitionsFoundException e) {
                        throw new RuntimeException("Could not determine the runtime definition to use. Multiple definitions were found: " + e.getDefinitions().stream().map(r1 -> r1.getSpecification().getVersionedName()).collect(Collectors.joining(", ")), e);
                    }
                    catch (NoDefinitionsFoundException e) {
                        throw new RuntimeException("Could not determine the runtime definition to use. No definitions were found.", e);
                    }
                });
            }));
            task.getInput().set(context.getInputTask().flatMap(OutputSpecification::getOutput));
            task.getOutput().set(context.getProject().getLayout().getBuildDirectory().dir("obfuscation/" + context.getInputTask().getName()).flatMap(directory -> directory.file(context.getInputTask().flatMap(OutputSpecification::getOutputFileName).orElse(context.getInputTask().flatMap(OutputSpecification::getOutput).map(RegularFile::getAsFile).map(File::getName)))));
            task.getLibraries().set(librariesTask.flatMap(OutputSpecification::getOutput));
            task.getMappings().set(context.getGameArtifactTask(GameArtifact.CLIENT_MAPPINGS).flatMap(OutputSpecification::getOutput));
            task.dependsOn(new Object[]{context.getInputTask()});
            task.dependsOn(new Object[]{librariesTask});
        });
        context.getInputTask().configure(task -> task.finalizedBy(new Object[]{applyTask}));
        return applyTask;
    }

    @Override
    public String getName() {
        return "rename";
    }
}

