/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.extensions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.tasks.UnpackBundledServer;
import net.neoforged.gradle.common.util.BundledServerUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.ArtifactProvider;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.vanilla.runtime.VanillaRuntimeDefinition;
import net.neoforged.gradle.vanilla.runtime.spec.VanillaRuntimeSpecification;
import net.neoforged.gradle.vanilla.runtime.steps.ApplyAccessTransformerStep;
import net.neoforged.gradle.vanilla.runtime.steps.CleanManifestStep;
import net.neoforged.gradle.vanilla.runtime.steps.CollectLibraryInformationStep;
import net.neoforged.gradle.vanilla.runtime.steps.DecompileStep;
import net.neoforged.gradle.vanilla.runtime.steps.ExtractBundledServerStep;
import net.neoforged.gradle.vanilla.runtime.steps.IStep;
import net.neoforged.gradle.vanilla.runtime.steps.ParchmentStep;
import net.neoforged.gradle.vanilla.runtime.steps.RenameStep;
import net.neoforged.gradle.vanilla.util.ServerLaunchInformation;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class VanillaRuntimeExtension
extends CommonRuntimeExtension<VanillaRuntimeSpecification, VanillaRuntimeSpecification.Builder, VanillaRuntimeDefinition> {
    @Inject
    public VanillaRuntimeExtension(Project project) {
        super(project);
        this.getVineFlowerVersion().convention((Object)"1.9.3");
        this.getFartVersion().convention((Object)"2.0.3");
        this.getAccessTransformerApplierVersion().convention((Object)"10.0.+");
    }

    @NotNull
    protected VanillaRuntimeDefinition doCreate(VanillaRuntimeSpecification spec) {
        VersionJson versionJson;
        File serverJar;
        if (this.runtimes.containsKey(spec.getIdentifier())) {
            throw new IllegalArgumentException("Cannot register runtime with identifier '" + spec.getIdentifier() + "' because it already exists");
        }
        Project project = spec.getProject();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        MinecraftArtifactCache artifactCacheExtension = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        File minecraftCache = ((Directory)artifactCacheExtension.getCacheDirectory().get()).getAsFile();
        Map gameArtifacts = artifactCacheExtension.cacheGameVersion(spec.getMinecraftVersion(), spec.getDistribution());
        if (gameArtifacts.containsKey(GameArtifact.SERVER_JAR) && BundledServerUtils.isBundledServer((File)(serverJar = (File)gameArtifacts.get(GameArtifact.SERVER_JAR)))) {
            File vanillaServerJar = new File(minecraftCache, String.format("minecraft_server.%s.jar", spec.getMinecraftVersion()));
            BundledServerUtils.extractBundledVersion((File)serverJar, (File)vanillaServerJar);
            gameArtifacts.put(GameArtifact.SERVER_JAR, vanillaServerJar);
        }
        try {
            versionJson = VersionJson.get((File)((File)gameArtifacts.get(GameArtifact.VERSION_MANIFEST)));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to read VersionJson from the launcher metadata for the minecraft version: %s", spec.getMinecraftVersion()), e);
        }
        Configuration minecraftDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (Dependency[])new Dependency[0]);
        if (spec.getDistribution().isClient() || !BundledServerUtils.isBundledServer((File)((File)gameArtifacts.get(GameArtifact.SERVER_JAR)))) {
            for (VersionJson.Library library : versionJson.getLibraries()) {
                minecraftDependenciesConfiguration.getDependencies().add((Object)spec.getProject().getDependencies().create((Object)library.getName()));
            }
        } else {
            BundledServerUtils.getBundledDependencies((File)((File)gameArtifacts.get(GameArtifact.SERVER_JAR))).forEach(dependency -> minecraftDependenciesConfiguration.getDependencies().add((Object)spec.getProject().getDependencies().create(dependency)));
        }
        File vanillaDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("vanilla/%s", spec.getIdentifier())).get()).getAsFile();
        File runtimeWorkingDirectory = new File(vanillaDirectory, "runtime");
        File stepsMcpDirectory = new File(vanillaDirectory, "steps");
        stepsMcpDirectory.mkdirs();
        Map gameArtifactTasks = VanillaRuntimeExtension.buildDefaultArtifactProviderTasks((Specification)spec);
        if (gameArtifactTasks.containsKey(GameArtifact.SERVER_JAR) && BundledServerUtils.isBundledServer((File)((File)gameArtifacts.get(GameArtifact.SERVER_JAR)))) {
            TaskProvider serverJarTask = (TaskProvider)gameArtifactTasks.get(GameArtifact.SERVER_JAR);
            TaskProvider extractedBundleTask = project.getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"extractBundle"), UnpackBundledServer.class, task -> {
                task.getServerJar().set(serverJarTask.flatMap(OutputSpecification::getOutput));
                task.getOutput().fileValue(new File(vanillaDirectory, "files/server.jar"));
            });
            extractedBundleTask.configure(task -> task.dependsOn(new Object[]{serverJarTask}));
            gameArtifactTasks.put(GameArtifact.SERVER_JAR, extractedBundleTask);
        }
        TaskProvider sourceJarTask = spec.getProject().getTasks().register("supplySourcesFor" + spec.getIdentifier(), ArtifactProvider.class, task -> task.getOutput().set(new File(runtimeWorkingDirectory, "sources.jar")));
        TaskProvider rawJarTask = spec.getProject().getTasks().register("supplyRawJarFor" + spec.getIdentifier(), ArtifactProvider.class, task -> task.getOutput().set(new File(runtimeWorkingDirectory, "raw.jar")));
        Optional<ServerLaunchInformation> launchInformation = spec.getDistribution().isClient() ? Optional.empty() : Optional.of(ServerLaunchInformation.from((File)gameArtifacts.get(GameArtifact.SERVER_JAR)));
        return new VanillaRuntimeDefinition(spec, new LinkedHashMap<String, TaskProvider<? extends WithOutput>>(), (TaskProvider<? extends ArtifactProvider>)sourceJarTask, (TaskProvider<? extends ArtifactProvider>)rawJarTask, gameArtifactTasks, minecraftDependenciesConfiguration, taskProvider -> taskProvider.configure(vanillaRuntimeTask -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)vanillaRuntimeTask, (String)CommonRuntimeUtils.buildStepName((Specification)spec, (String)vanillaRuntimeTask.getName()), (CommonRuntimeSpecification)spec, (File)vanillaDirectory)), versionJson, (TaskProvider<DownloadAssets>)this.createDownloadAssetsTasks(spec, runtimeWorkingDirectory, versionJson), (TaskProvider<ExtractNatives>)this.createExtractNativesTasks(spec, runtimeWorkingDirectory, versionJson), launchInformation);
    }

    protected VanillaRuntimeSpecification.Builder createBuilder() {
        return VanillaRuntimeSpecification.Builder.from(this.getProject());
    }

    protected void bakeDefinition(VanillaRuntimeDefinition definition) {
        VanillaRuntimeSpecification spec = (VanillaRuntimeSpecification)definition.getSpecification();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        MinecraftArtifactCache artifactCacheExtension = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        File minecraftCache = ((Directory)artifactCacheExtension.getCacheDirectory().get()).getAsFile();
        File vanillaDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("vanilla/%s", spec.getIdentifier())).get()).getAsFile();
        File runtimeWorkingDirectory = new File(vanillaDirectory, "runtime");
        File stepsMcpDirectory = new File(vanillaDirectory, "steps");
        StepData stepData = this.buildSteps();
        List<IStep> steps = stepData.getSteps();
        TaskProvider currentInput = (TaskProvider)definition.getGameArtifactProvidingTasks().get(spec.getDistribution().getGameArtifact());
        for (IStep step : steps) {
            if (spec.getPreTaskTypeAdapters().containsKey((Object)step.getName()) && !spec.getPreTaskTypeAdapters().get((Object)step.getName()).isEmpty()) {
                int taskPreAdapterIndex = 0;
                for (TaskTreeAdapter taskTreeAdapter : spec.getPreTaskTypeAdapters().get((Object)step.getName())) {
                    AtomicInteger additionalPreAdapterTasks = new AtomicInteger(0);
                    int currentTaskPreAdapterIndex = taskPreAdapterIndex++;
                    TaskProvider modifiedTree = taskTreeAdapter.adapt((Definition)definition, currentInput, vanillaDirectory, definition.getGameArtifactProvidingTasks(), definition.getMappingVersionData(), taskProvider -> taskProvider.configure(task -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (String)(step.getName() + "PreAdapter" + currentTaskPreAdapterIndex + "-" + additionalPreAdapterTasks.getAndIncrement()), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory)));
                    if (modifiedTree == null) continue;
                    modifiedTree.configure(task -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)task, (String)(step.getName() + "PreAdapter" + currentTaskPreAdapterIndex + "-" + additionalPreAdapterTasks.getAndIncrement()), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory));
                    currentInput = modifiedTree;
                }
            }
            AtomicInteger additionalTaskIndex = new AtomicInteger(0);
            TaskProvider task2 = step.buildTask(definition, (TaskProvider<? extends WithOutput>)currentInput, minecraftCache, vanillaDirectory, definition.getTasks(), definition.getGameArtifactProvidingTasks(), taskProvider -> taskProvider.configure(additionalTask -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)additionalTask, (String)(step.getName() + "Additional" + additionalTaskIndex.getAndIncrement()), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory)));
            task2.configure(mcpRuntimeTask -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)mcpRuntimeTask, (String)step.getName(), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory));
            if (!spec.getPostTypeAdapters().containsKey((Object)step.getName())) {
                definition.getTasks().put(task2.getName(), task2);
            } else {
                int taskPostAdapterIndex = 0;
                for (TaskTreeAdapter taskTreeAdapter : spec.getPostTypeAdapters().get((Object)step.getName())) {
                    AtomicInteger additionalPostAdapterTasks = new AtomicInteger(0);
                    int currentPostAdapterIndex = taskPostAdapterIndex++;
                    TaskProvider taskProvider2 = taskTreeAdapter.adapt((Definition)definition, (Provider)task2, vanillaDirectory, definition.getGameArtifactProvidingTasks(), definition.getMappingVersionData(), dependentTaskProvider -> dependentTaskProvider.configure(additionalTask -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)additionalTask, (String)(step.getName() + "PostAdapter" + currentPostAdapterIndex + "-" + additionalPostAdapterTasks.getAndIncrement()), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory)));
                    if (taskProvider2 == null) continue;
                    taskProvider2.configure(adaptedTask -> VanillaRuntimeExtension.configureCommonRuntimeTaskParameters((Runtime)adaptedTask, (String)(step.getName() + "PostAdapter" + currentPostAdapterIndex + "-" + additionalPostAdapterTasks.getAndIncrement()), (CommonRuntimeSpecification)spec, (File)runtimeWorkingDirectory));
                    task2 = taskProvider2;
                }
                definition.getTasks().put(task2.getName(), task2);
            }
            currentInput = task2;
        }
        TaskProvider sourcesTask = (TaskProvider)Iterators.getLast(definition.getTasks().values().iterator());
        TaskProvider rawTask = (TaskProvider)definition.getTasks().get(stepData.getRawJarStep().getTaskName(definition));
        definition.getSourceJarTask().configure(task -> {
            task.getInputFiles().from(new Object[]{sourcesTask.flatMap(OutputSpecification::getOutput)});
            task.dependsOn(new Object[]{sourcesTask});
        });
        definition.getRawJarTask().configure(task -> {
            task.getInputFiles().from(new Object[]{rawTask.flatMap(OutputSpecification::getOutput)});
            task.dependsOn(new Object[]{rawTask});
        });
        definition.onBake((NamingChannel)((Mappings)this.getProject().getExtensions().getByType(Mappings.class)).getChannel().get(), runtimeWorkingDirectory);
    }

    private StepData buildSteps() {
        CleanManifestStep rawJarStep = new CleanManifestStep();
        ParchmentStep sourcesStep = new ParchmentStep();
        ImmutableList steps = ImmutableList.builder().add((Object)new CollectLibraryInformationStep()).add((Object)new ExtractBundledServerStep()).add((Object)new RenameStep()).add((Object)rawJarStep).add((Object)new DecompileStep()).add((Object)new ApplyAccessTransformerStep()).add((Object)sourcesStep).build();
        return new StepData((List)steps, rawJarStep, sourcesStep);
    }

    public abstract Property<DistributionType> getDefaultDistributionType();

    public abstract Property<String> getVersion();

    public abstract Property<String> getFartVersion();

    public abstract Property<String> getVineFlowerVersion();

    public abstract Property<String> getAccessTransformerApplierVersion();

    private static final class StepData {
        private final List<IStep> steps;
        private final IStep rawJarStep;
        private final IStep sourceJarStep;

        private StepData(List<IStep> steps, IStep rawJarStep, IStep sourceJarStep) {
            this.steps = steps;
            this.rawJarStep = rawJarStep;
            this.sourceJarStep = sourceJarStep;
        }

        public List<IStep> getSteps() {
            return this.steps;
        }

        public IStep getRawJarStep() {
            return this.rawJarStep;
        }

        public IStep getSourceJarStep() {
            return this.sourceJarStep;
        }
    }
}

