/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.vanilla.runtime.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.util.DelegatingFileTreeVisitor;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CleanArtifact
extends DefaultRuntime {
    @TaskAction
    public void doClean() {
        try {
            File outputJar = this.ensureFileWorkspaceReady(this.getOutput());
            FileOutputStream fileOutputStream = new FileOutputStream(outputJar);
            ZipOutputStream outputZipStream = new ZipOutputStream(fileOutputStream);
            DelegatingFileTreeVisitor visitor = new DelegatingFileTreeVisitor((FileVisitor)new ZipBuildingFileTreeVisitor(outputZipStream)){

                public void visitDir(FileVisitDetails fileVisitDetails) {
                    if (!(fileVisitDetails.getRelativePath().getPathString().startsWith("assets/") || fileVisitDetails.getRelativePath().getPathString().startsWith("data/") || fileVisitDetails.getRelativePath().getPathString().startsWith("net/") || fileVisitDetails.getRelativePath().getPathString().startsWith("META-INF/") || fileVisitDetails.getRelativePath().getPathString().contains("mojang") || fileVisitDetails.getRelativePath().getPathString().contains("minecraft"))) {
                        return;
                    }
                    super.visitDir(fileVisitDetails);
                }

                public void visitFile(FileVisitDetails fileVisitDetails) {
                    if (fileVisitDetails.getRelativePath().getPathString().equals("META-INF/MANIFEST.MF")) {
                        return;
                    }
                    if (!(!fileVisitDetails.getRelativePath().getPathString().contains("/") || fileVisitDetails.getRelativePath().getPathString().startsWith("assets/") || fileVisitDetails.getRelativePath().getPathString().startsWith("data/") || fileVisitDetails.getRelativePath().getPathString().startsWith("net/") || fileVisitDetails.getRelativePath().getPathString().startsWith("META-INF/") || fileVisitDetails.getRelativePath().getPathString().contains("mojang") || fileVisitDetails.getRelativePath().getPathString().contains("minecraft"))) {
                        return;
                    }
                    super.visitFile(fileVisitDetails);
                }
            };
            this.getArchiveOperations().zipTree(this.getInput().get()).visit((FileVisitor)visitor);
            outputZipStream.close();
            fileOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create cleaned output jar", e);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();
}

