/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;

public class DirectoryTreeBuildingFileTreeVisitor
implements FileVisitor {
    private final Path root;

    public DirectoryTreeBuildingFileTreeVisitor(Path root) {
        this.root = root;
        CopyingFileTreeVisitor.initTargetDirectory(root);
    }

    public void visitDir(FileVisitDetails dirDetails) {
        Path target = this.root.resolve(dirDetails.getPath());
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GradleException("Failed to create the directory tree element: " + dirDetails.getPath() + " under: " + String.valueOf(this.root.toAbsolutePath()), (Throwable)e);
        }
    }

    public void visitFile(FileVisitDetails fileDetails) {
        Path target = this.root.resolve(fileDetails.getPath()).getParent();
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GradleException("Failed to create the directory tree element: " + fileDetails.getPath() + " under: " + String.valueOf(this.root.toAbsolutePath()), (Throwable)e);
        }
    }
}

