/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.util.AdaptingZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassVisitingFileTreeVisitor
extends AdaptingZipBuildingFileTreeVisitor {
    public ClassVisitingFileTreeVisitor(ZipOutputStream outputZipStream, VisitorBuilder builder) {
        super(outputZipStream, (FileVisitDetails details, OutputStream outputStream) -> {
            if (!details.getName().endsWith(".class")) {
                details.copyTo(outputStream);
                return;
            }
            try (InputStream stream = details.open();){
                ClassReader cr = new ClassReader(stream);
                ClassWriter cw = new ClassWriter(1);
                ClassVisitor cv = builder.build(589824, (ClassVisitor)cw);
                cr.accept(cv, 0);
                outputStream.write(cw.toByteArray());
            }
        });
    }

    public static interface VisitorBuilder {
        public ClassVisitor build(int var1, ClassVisitor var2);
    }
}

