/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.util.Locale;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDependencyUtils {
    private ModuleDependencyUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ModuleDependencyUtils. This is a utility class");
    }

    @Nullable
    public static String getClassifier(ModuleDependency moduleDependency) {
        if (moduleDependency.getArtifacts().isEmpty()) {
            return null;
        }
        return ((DependencyArtifact)moduleDependency.getArtifacts().iterator().next()).getClassifier();
    }

    @NotNull
    public static String getClassifierOrEmpty(Dependency moduleDependency) {
        if (!(moduleDependency instanceof ModuleDependency)) {
            return "";
        }
        return ModuleDependencyUtils.getClassifierOrEmpty((ModuleDependency)moduleDependency);
    }

    @NotNull
    public static String getClassifierOrEmpty(ModuleDependency moduleDependency) {
        String artifactClassifier = ModuleDependencyUtils.getClassifier(moduleDependency);
        return artifactClassifier == null ? "" : artifactClassifier;
    }

    @Nullable
    public static String getExtension(ModuleDependency moduleDependency) {
        if (moduleDependency.getArtifacts().isEmpty()) {
            return null;
        }
        return ((DependencyArtifact)moduleDependency.getArtifacts().iterator().next()).getExtension();
    }

    @NotNull
    public static String getExtensionOrJar(Dependency moduleDependency) {
        if (!(moduleDependency instanceof ModuleDependency)) {
            return "jar";
        }
        return ModuleDependencyUtils.getExtensionOrJar((ModuleDependency)moduleDependency);
    }

    @NotNull
    public static String getExtensionOrJar(ModuleDependency moduleDependency) {
        String artifactExtension = ModuleDependencyUtils.getExtension(moduleDependency);
        return artifactExtension == null ? "jar" : artifactExtension;
    }

    public static String format(Dependency dependency) {
        if (!(dependency instanceof ModuleDependency)) {
            throw new IllegalArgumentException("Dependency is not a ModuleDependency");
        }
        return ModuleDependencyUtils.format((ModuleDependency)dependency);
    }

    public static String format(ModuleDependency dependency) {
        return ModuleDependencyUtils.format(dependency.getGroup(), dependency.getName(), dependency.getVersion(), ModuleDependencyUtils.getClassifierOrEmpty(dependency), ModuleDependencyUtils.getExtensionOrJar(dependency));
    }

    public static String format(@Nullable String group, String name, String version, String classifier, String extension) {
        StringBuilder builder = new StringBuilder();
        if (group != null && !group.trim().isEmpty()) {
            builder.append(group);
            builder.append(":");
        }
        builder.append(name);
        builder.append(":");
        builder.append(version);
        if (classifier != null && !classifier.trim().isEmpty()) {
            builder.append(":");
            builder.append(classifier);
        }
        if (extension != null && !extension.trim().isEmpty() && !extension.trim().toLowerCase(Locale.ROOT).equals("jar")) {
            builder.append("@").append(extension);
        }
        return builder.toString();
    }

    public static String toConfigurationName(String s) {
        return s.toLowerCase(Locale.ROOT).replace('-', '_').replace('.', '_').replace(":", "_");
    }

    public static String toConfigurationName(Dependency dependency) {
        return ModuleDependencyUtils.toConfigurationName(ModuleDependencyUtils.format(dependency));
    }
}

