/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResolvedDependencyUtils {
    private ResolvedDependencyUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ResolvedDependencyUtils. This is a utility class");
    }

    @Nullable
    public static String getClassifier(ResolvedDependency resolvedDependency) {
        if (resolvedDependency.getModuleArtifacts().isEmpty()) {
            return null;
        }
        return ((ResolvedArtifact)resolvedDependency.getModuleArtifacts().iterator().next()).getClassifier();
    }

    @NotNull
    public static String getClassifierOrEmpty(ResolvedDependency resolvedDependency) {
        String artifactClassifier = ResolvedDependencyUtils.getClassifier(resolvedDependency);
        return artifactClassifier == null ? "" : artifactClassifier;
    }

    @Nullable
    public static String getExtension(ResolvedDependency resolvedDependency) {
        if (resolvedDependency.getModuleArtifacts().isEmpty()) {
            return null;
        }
        return ((ResolvedArtifact)resolvedDependency.getModuleArtifacts().iterator().next()).getExtension();
    }

    @NotNull
    public static String getExtensionOrJar(ResolvedDependency resolvedDependency) {
        String artifactExtension = ResolvedDependencyUtils.getExtension(resolvedDependency);
        return artifactExtension == null ? "jar" : artifactExtension;
    }

    @NotNull
    public static String toFileName(ResolvedDependency resolvedDependency) {
        return resolvedDependency.getName().replace(":", "/");
    }
}

