/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.util.function.Predicate;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileVisitDetails;

public class FilteringZipBuildingFileTreeVisitor
extends ZipBuildingFileTreeVisitor {
    private final Predicate<FileVisitDetails> directoryFilter;
    private final Predicate<FileVisitDetails> fileFilter;

    public FilteringZipBuildingFileTreeVisitor(ZipOutputStream outputZipStream, Predicate<FileVisitDetails> directoryFilter, Predicate<FileVisitDetails> fileFilter) {
        super(outputZipStream);
        this.directoryFilter = directoryFilter;
        this.fileFilter = fileFilter;
    }

    @Override
    public void visitDir(FileVisitDetails fileVisitDetails) {
        if (!this.directoryFilter.test(fileVisitDetails)) {
            return;
        }
        super.visitDir(fileVisitDetails);
    }

    @Override
    public void visitFile(FileVisitDetails fileVisitDetails) {
        if (!this.fileFilter.test(fileVisitDetails)) {
            return;
        }
        super.visitFile(fileVisitDetails);
    }
}

