/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileVisitDetails;

public class AdaptingZipBuildingFileTreeVisitor
extends ZipBuildingFileTreeVisitor {
    private final Adapter fileAdapter;

    public AdaptingZipBuildingFileTreeVisitor(ZipOutputStream outputZipStream, Adapter fileAdapter) {
        super(outputZipStream);
        this.fileAdapter = fileAdapter;
    }

    @Override
    public void visitFile(FileVisitDetails fileVisitDetails) {
        try {
            ZipEntry fileEntry = new ZipEntry(fileVisitDetails.getRelativePath().getPathString());
            this.outputZipStream.putNextEntry(fileEntry);
            this.fileAdapter.accept(fileVisitDetails, this.outputZipStream);
            this.outputZipStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create zip file: " + fileVisitDetails.getRelativePath().getPathString(), e);
        }
    }

    public static interface Adapter {
        public void accept(FileVisitDetails var1, OutputStream var2) throws IOException;
    }
}

