/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleDependencyUtils {
    private ModuleDependencyUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ModuleDependencyUtils. This is a utility class");
    }

    @Nullable
    public static String getClassifier(ModuleDependency moduleDependency) {
        if (moduleDependency.getArtifacts().isEmpty()) {
            return null;
        }
        return ((DependencyArtifact)moduleDependency.getArtifacts().iterator().next()).getClassifier();
    }

    @NotNull
    public static String getClassifierOrEmpty(ModuleDependency moduleDependency) {
        String artifactClassifier = ModuleDependencyUtils.getClassifier(moduleDependency);
        return artifactClassifier == null ? "" : artifactClassifier;
    }

    @Nullable
    public static String getExtension(ModuleDependency moduleDependency) {
        if (moduleDependency.getArtifacts().isEmpty()) {
            return null;
        }
        return ((DependencyArtifact)moduleDependency.getArtifacts().iterator().next()).getExtension();
    }

    @NotNull
    public static String getExtensionOrJar(ModuleDependency moduleDependency) {
        String artifactExtension = ModuleDependencyUtils.getExtension(moduleDependency);
        return artifactExtension == null ? "jar" : artifactExtension;
    }
}

