/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.gradle.util.FileUtils;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.jetbrains.annotations.VisibleForTesting;

public class CopyingFileTreeVisitor
implements FileVisitor {
    private final Path directory;
    private final boolean processDirectories;

    public CopyingFileTreeVisitor(Path directory, boolean processDirectories) {
        this.directory = directory;
        this.processDirectories = processDirectories;
        CopyingFileTreeVisitor.initTargetDirectory(directory);
    }

    public CopyingFileTreeVisitor(File directory, boolean processDirectories) {
        this(directory.toPath(), processDirectories);
    }

    public CopyingFileTreeVisitor(Path directory) {
        this(directory, true);
    }

    public CopyingFileTreeVisitor(File directory) {
        this(directory, true);
    }

    @VisibleForTesting
    static void initTargetDirectory(Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create directory: " + directory, e);
            }
        }
        if (Files.isRegularFile(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("The given path is a file, not a directory: " + directory);
        }
        try {
            FileUtils.delete(directory);
        }
        catch (IOException e) {
            throw new RuntimeException("Cloud not clean up target directory: " + directory, e);
        }
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create directory: " + directory, e);
        }
    }

    public void visitDir(FileVisitDetails dirDetails) {
        if (!this.processDirectories) {
            return;
        }
        Path target = this.directory.resolve(dirDetails.getRelativePath().getPathString());
        try {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create directory: " + target, e);
        }
    }

    public void visitFile(FileVisitDetails fileDetails) {
        Path target = this.directory.resolve(fileDetails.getRelativePath().getPathString());
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            fileDetails.copyTo(Files.newOutputStream(target, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create file: " + target, e);
        }
    }

    @VisibleForTesting
    Path getDirectory() {
        return this.directory;
    }
}

