/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import groovy.lang.Closure;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.util.internal.ConfigureUtil;

public final class GradleInternalUtils {
    private GradleInternalUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: GradleInternalUtils. This is a utility class");
    }

    public static Collection<Object> getExtensions(ExtensionContainer container) {
        return ((ExtensionContainerInternal)container).getAsMap().values();
    }

    public static <T> T configureSelf(Closure<?> closure, T t) {
        return (T)ConfigureUtil.configureSelf(closure, t);
    }

    public static <T> T configureByMap(Map<?, ?> properties, T delegate) {
        return (T)ConfigureUtil.configureByMap(properties, delegate);
    }

    public static ProgressLoggerWrapper getProgressLogger(Logger logger, Object serviceOwner, String name) {
        try {
            ProgressLoggerWrapper wrapper = new ProgressLoggerWrapper(logger);
            wrapper.init(serviceOwner, name);
            return wrapper;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to get progress logger", e);
        }
    }

    public static class ProgressLoggerWrapper {
        private final Logger logger;
        private Object progressLogger;
        private String size;
        private String destFileName;
        private long processedBytes = 0L;
        private long loggedKb = 0L;
        private String actionType = "downloaded";

        private ProgressLoggerWrapper(Logger logger) {
            this.logger = logger;
        }

        private void init(Object servicesOwner, String src) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, InvocationTargetException, IllegalAccessException {
            Object serviceFactory;
            Class<?> progressLoggerFactoryClass = Class.forName("org.gradle.internal.logging.progress.ProgressLoggerFactory");
            try {
                serviceFactory = ProgressLoggerWrapper.invoke(servicesOwner, "getServices", new Object[0]);
            }
            catch (Throwable ignored) {
                serviceFactory = ProgressLoggerWrapper.getFieldValue(servicesOwner, "services");
            }
            Object progressLoggerFactory = ProgressLoggerWrapper.invoke(serviceFactory, "get", progressLoggerFactoryClass);
            this.progressLogger = ProgressLoggerWrapper.invoke(progressLoggerFactory, "newOperation", this.getClass());
            String desc = "Download " + src;
            ProgressLoggerWrapper.invoke(this.progressLogger, "setDescription", desc);
        }

        private static Class<?> getReflectionTarget(Class<?> cls) {
            if (Arrays.asList(cls.getInterfaces()).contains(GeneratedSubclass.class)) {
                return cls.getSuperclass();
            }
            return cls;
        }

        private static Object invoke(Object obj, String method, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            Class[] argumentTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argumentTypes[i] = args[i].getClass();
            }
            Method m = ProgressLoggerWrapper.findMethod(obj, method, argumentTypes);
            m.setAccessible(true);
            return m.invoke(obj, args);
        }

        private static Object getFieldValue(Object obj, String name) throws NoSuchFieldException, IllegalAccessException {
            for (Class<?> clazz = ProgressLoggerWrapper.getReflectionTarget(obj.getClass()); clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!field.getName().equals(name)) continue;
                    field.setAccessible(true);
                    return field.get(obj);
                }
            }
            throw new NoSuchFieldException("Field " + name + " on " + String.valueOf(obj.getClass()));
        }

        private static Method findMethod(Object obj, String methodName, Class<?>[] argumentTypes) throws NoSuchMethodException {
            for (Class<?> clazz = ProgressLoggerWrapper.getReflectionTarget(obj.getClass()); clazz != null; clazz = clazz.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), argumentTypes)) continue;
                    return method;
                }
            }
            throw new NoSuchMethodException("Method " + methodName + "(" + Arrays.toString(argumentTypes) + ") on " + String.valueOf(obj.getClass()));
        }

        private void invokeIgnoreExceptions(Object obj, String method, Object ... args) {
            try {
                ProgressLoggerWrapper.invoke(obj, method, args);
            }
            catch (ReflectiveOperationException e) {
                this.logger.trace("Unable to log progress", (Throwable)e);
            }
        }

        public void started() {
            if (this.progressLogger != null) {
                this.invokeIgnoreExceptions(this.progressLogger, "started", new Object[0]);
            }
        }

        public void completed() {
            if (this.progressLogger != null) {
                this.invokeIgnoreExceptions(this.progressLogger, "completed", new Object[0]);
            }
        }

        private void progress(String msg) {
            if (this.progressLogger != null) {
                this.invokeIgnoreExceptions(this.progressLogger, "progress", msg);
            }
        }

        public void setSize(long size) {
            this.size = ProgressLoggerWrapper.toLengthText(size);
            this.processedBytes = 0L;
            this.loggedKb = 0L;
        }

        public void setDestFileName(String destFileName) {
            this.destFileName = destFileName;
        }

        public void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public void incrementDownloadProgress(long increment) {
            this.processedBytes += increment;
            this.setActionType("downloaded");
            if (this.progressLogger == null) {
                return;
            }
            long processedKb = this.processedBytes / 1024L;
            if (processedKb > this.loggedKb) {
                StringBuilder sb = new StringBuilder();
                if (this.destFileName != null) {
                    sb.append(this.destFileName);
                    sb.append(" > ");
                }
                sb.append(ProgressLoggerWrapper.toLengthText(this.processedBytes));
                if (this.size != null) {
                    sb.append("/");
                    sb.append(this.size);
                }
                sb.append(" ").append(this.actionType);
                this.progress(sb.toString());
                this.loggedKb = processedKb;
            }
        }

        public void incrementProcessedFileCount() {
            ++this.processedBytes;
            if (this.progressLogger == null) {
                return;
            }
            if (this.processedBytes > this.loggedKb) {
                this.loggedKb = this.processedBytes;
                StringBuilder sb = new StringBuilder();
                if (this.destFileName != null) {
                    sb.append(this.destFileName);
                    sb.append(" > ");
                }
                sb.append(ProgressLoggerWrapper.toCountText(this.processedBytes));
                if (this.size != null) {
                    sb.append("/");
                    sb.append(this.size);
                }
                sb.append(" ").append(this.actionType);
                this.progress(sb.toString());
            }
        }

        private static String toLengthText(long bytes) {
            if (bytes < 1024L) {
                return bytes + " B";
            }
            if (bytes < 0x100000L) {
                return bytes / 1024L + " KB";
            }
            if (bytes < 0x40000000L) {
                return String.format("%.2f MB", (double)bytes / 1048576.0);
            }
            return String.format("%.2f GB", (double)bytes / 1.073741824E9);
        }

        private static String toCountText(long bytes) {
            if (bytes < 1024L) {
                return String.valueOf(bytes);
            }
            if (bytes < 0x100000L) {
                return bytes / 1024L + "k";
            }
            if (bytes < 0x40000000L) {
                return String.format("%.2fm", (double)bytes / 1048576.0);
            }
            return String.format("%.2fg", (double)bytes / 1.073741824E9);
        }
    }
}

