/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import groovyjarjarantlr4.v4.runtime.misc.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerUtils.class);

    private TransformerUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: TransformerUtils. This is a utility class");
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard) {
        return t -> {
            try {
                return toGuard.transform(t);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
        };
    }

    public static <V, T, S extends AutoCloseable> Transformer<V, T> guardWithResource(ThrowingTransformer<V, S> toGuard, ThrowingFunction<T, S> factory) {
        return t -> {
            Object v;
            block8: {
                AutoCloseable closeable = (AutoCloseable)factory.apply(t);
                try {
                    v = toGuard.transform(closeable);
                    if (closeable == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to transform: " + t, e);
                        throw new RuntimeException("Failed to transform: " + t, e);
                    }
                }
                closeable.close();
            }
            return v;
        };
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard, Consumer<Throwable> onFailure) {
        return t -> {
            try {
                return toGuard.transform(t);
            }
            catch (Throwable e) {
                onFailure.accept(e);
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
        };
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard, Runnable before, Consumer<V> after, Consumer<Throwable> onFailure, Runnable finalizer) {
        return t -> {
            try {
                before.run();
                Object ret = toGuard.transform(t);
                after.accept(ret);
                Object v = ret;
                return v;
            }
            catch (Throwable e) {
                onFailure.accept(e);
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
            finally {
                finalizer.run();
            }
        };
    }

    public static <V> Transformer<V, V> peak(Consumer<V> peakConsumer) {
        return t -> {
            peakConsumer.accept(t);
            return t;
        };
    }

    public static <V> ThrowingTransformer<V, V> peakWithThrow(ThrowingConsumer<V> peakConsumer) {
        return t -> {
            peakConsumer.apply(t);
            return t;
        };
    }

    public static <V extends FileSystemLocation> Transformer<V, V> ensureExists() {
        return TransformerUtils.guard(t -> {
            if (!t.getAsFile().exists()) {
                if (t instanceof Directory) {
                    t.getAsFile().mkdirs();
                } else {
                    t.getAsFile().createNewFile();
                }
            }
            return t;
        });
    }

    public static <K, V, I, C extends List<I>> Transformer<? extends Provider<Map<K, V>>, C> combineAllMaps(Project project, Class<K> keyClass, Class<V> valueClass, Function<I, Provider<Map<K, V>>> valueProvider) {
        MapProperty map = project.getObjects().mapProperty(keyClass, valueClass);
        return TransformerUtils.guard(t -> {
            for (Object i : t) {
                map.putAll((Provider)valueProvider.apply(i));
            }
            return map;
        });
    }

    public static <V, I, C extends List<I>> Transformer<? extends Provider<V>, C> takeLast(Project project, Function<I, Provider<V>> valueProvider) {
        return TransformerUtils.guard(t -> {
            Provider result = project.provider(() -> null);
            if (t.isEmpty()) {
                return result;
            }
            for (int i = t.size() - 1; i >= 0; --i) {
                result = result.orElse((Provider)valueProvider.apply(t.get(i)));
            }
            return result;
        });
    }

    public static <V, I, C extends List<I>> Transformer<? extends Provider<? extends Iterable<V>>, C> combineAllLists(Project project, Class<V> valueClass, Function<I, Provider<List<V>>> valueProvider) {
        return TransformerUtils.guard(t -> {
            ListProperty values = project.getObjects().listProperty(valueClass);
            for (Object i : t) {
                values.addAll((Provider)valueProvider.apply(i));
            }
            return values;
        });
    }

    public static <I, C extends Collection<I>> Transformer<? extends ConfigurableFileCollection, C> combineFileCollections(Project project, Function<I, ConfigurableFileCollection> valueProvider) {
        return TransformerUtils.guard(t -> {
            ConfigurableFileCollection files = project.files(new Object[0]);
            for (Object i : t) {
                files.from(new Object[]{valueProvider.apply(i)});
            }
            return files;
        });
    }

    @SafeVarargs
    public static <V> Provider<? extends List<V>> ifTrue(Provider<Boolean> predicate, Provider<? extends V> ... whenTrue) {
        if (whenTrue.length == 0) {
            return predicate.map(p -> List.of());
        }
        if (whenTrue.length == 1) {
            return whenTrue[0].zip(predicate, (v, p) -> p != false ? List.of(v) : List.of());
        }
        Provider zippedArray = whenTrue[0].zip(predicate, (v, p) -> p != false ? List.of(v) : List.of());
        for (int i = 1; i < whenTrue.length; ++i) {
            zippedArray = zippedArray.zip(whenTrue[1].zip(predicate, (v, p) -> p != false ? List.of(v) : List.of()), (vs, objects) -> {
                ArrayList ret = new ArrayList(vs);
                ret.addAll(objects);
                return ret;
            });
        }
        return zippedArray;
    }

    @SafeVarargs
    public static <V> Provider<? extends List<V>> ifTrue(Provider<Boolean> predicate, V ... whenTrue) {
        if (whenTrue.length == 0) {
            return predicate.map(p -> List.of());
        }
        return predicate.map(p -> p != false ? List.of(whenTrue) : List.of());
    }

    public static <K, V> Provider<? extends Map<K, V>> ifTrueMap(Provider<Boolean> predicate, K keyWhenTrue, V valueWhenTrue) {
        return predicate.map(p -> p != false ? Map.of(keyWhenTrue, valueWhenTrue) : Map.of());
    }

    @SafeVarargs
    public static Transformer<Provider<Boolean>, Boolean> and(Provider<Boolean> ... rightProvider) {
        if (rightProvider.length == 0) {
            throw new IllegalStateException("No right provider provided");
        }
        if (rightProvider.length == 1) {
            return left -> rightProvider[0].map(o -> left != false && o != false);
        }
        return inputBoolean -> {
            Provider result = rightProvider[0].map(o -> inputBoolean != false && o != false);
            for (int i = 1; i < rightProvider.length; ++i) {
                result = result.zip(rightProvider[i], (l, r) -> l != false && r != false);
            }
            return result;
        };
    }

    @SafeVarargs
    public static Transformer<Provider<Boolean>, Boolean> or(Provider<Boolean> ... rightProvider) {
        if (rightProvider.length == 0) {
            throw new IllegalStateException("No right provider provided");
        }
        if (rightProvider.length == 1) {
            return left -> rightProvider[0].map(o -> left != false || o != false);
        }
        return inputBoolean -> {
            Provider result = rightProvider[0].map(o -> inputBoolean != false || o != false);
            for (int i = 1; i < rightProvider.length; ++i) {
                result = result.zip(rightProvider[i], (l, r) -> l != false || r != false);
            }
            return result;
        };
    }

    @FunctionalInterface
    public static interface ThrowingTransformer<V, T> {
        @Nullable
        public V transform(@NotNull T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, S> {
        public S apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<S> {
        public void apply(S var1) throws Throwable;
    }
}

