/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import groovyjarjarantlr4.v4.runtime.misc.NotNull;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformerUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformerUtils.class);

    private TransformerUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: TransformerUtils. This is a utility class");
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard) {
        return t -> {
            try {
                return toGuard.transform(t);
            }
            catch (Throwable e) {
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
        };
    }

    public static <V, T, S extends AutoCloseable> Transformer<V, T> guardWithResource(ThrowingTransformer<V, S> toGuard, ThrowingFunction<T, S> factory) {
        return t -> {
            Object v;
            block8: {
                AutoCloseable closeable = (AutoCloseable)factory.apply(t);
                try {
                    v = toGuard.transform(closeable);
                    if (closeable == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        LOGGER.error("Failed to transform: " + t, e);
                        throw new RuntimeException("Failed to transform: " + t, e);
                    }
                }
                closeable.close();
            }
            return v;
        };
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard, Consumer<Throwable> onFailure) {
        return t -> {
            try {
                return toGuard.transform(t);
            }
            catch (Throwable e) {
                onFailure.accept(e);
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
        };
    }

    public static <V, T> Transformer<V, T> guard(ThrowingTransformer<V, T> toGuard, Runnable before, Consumer<V> after, Consumer<Throwable> onFailure, Runnable finalizer) {
        return t -> {
            try {
                before.run();
                Object ret = toGuard.transform(t);
                after.accept(ret);
                Object v = ret;
                return v;
            }
            catch (Throwable e) {
                onFailure.accept(e);
                LOGGER.error("Failed to transform: " + t, e);
                throw new RuntimeException("Failed to transform: " + t, e);
            }
            finally {
                finalizer.run();
            }
        };
    }

    public static <V> Transformer<V, V> peak(Consumer<V> peakConsumer) {
        return t -> {
            peakConsumer.accept(t);
            return t;
        };
    }

    public static <V> ThrowingTransformer<V, V> peakWithThrow(ThrowingConsumer<V> peakConsumer) {
        return t -> {
            peakConsumer.apply(t);
            return t;
        };
    }

    public static <V extends FileSystemLocation> Transformer<V, V> ensureExists() {
        return TransformerUtils.guard(t -> {
            if (!t.getAsFile().exists()) {
                if (t instanceof Directory) {
                    t.getAsFile().mkdirs();
                } else {
                    t.getAsFile().createNewFile();
                }
            }
            return t;
        });
    }

    @FunctionalInterface
    public static interface ThrowingTransformer<V, T> {
        @Nullable
        public V transform(@NotNull T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, S> {
        public S apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<S> {
        public void apply(S var1) throws Throwable;
    }
}

