/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import com.google.common.collect.Sets;
import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.util.GradleInternalUtils;
import net.neoforged.gradle.util.TransformerUtils;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.gradle.api.Action;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.tasks.util.PatternFilterable;

public final class FileUtils {
    private static final int MAX_TRIES = 2;
    private static final long ZIPTIME = 628041600000L;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    private FileUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: FileUtils. This is a utility class");
    }

    public static byte[] readAllBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read all bytes!", e);
        }
    }

    public static Stream<String> readAllLines(Path path) {
        try {
            return Files.lines(path);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read all lines!", e);
        }
    }

    public static Path temporaryPath(Path parent, String key) throws IOException {
        return Files.createTempFile(parent, "." + key, "", new FileAttribute[0]);
    }

    public static void atomicMove(Path source, Path destination) throws IOException {
        try {
            FileUtils.atomicMoveIfPossible(source, destination);
        }
        catch (AccessDeniedException ex) {
            int tries = 0;
            while (true) {
                try {
                    Thread.sleep(10L * (long)tries);
                    FileUtils.atomicMoveIfPossible(source, destination);
                    return;
                }
                catch (AccessDeniedException ex2) {
                    if (tries == 1) {
                        throw ex;
                    }
                }
                catch (InterruptedException exInterrupt) {
                    Thread.currentThread().interrupt();
                    throw ex;
                }
                ++tries;
            }
        }
    }

    private static void atomicMoveIfPossible(Path source, Path destination) throws IOException {
        try {
            Files.move(source, destination, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException ex) {
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static int getFileSize(File asFile) {
        return FileUtils.readAllBytes(asFile.toPath()).length;
    }

    /*
     * Loose catch block
     */
    public static <T> T processFileFromZip(File zipArchivePath, String pathInArchive, TransformerUtils.ThrowingFunction<InputStream, T> processor) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipArchivePath);){
            T t;
            InputStream in;
            block15: {
                ZipEntry entry = zipFile.getEntry(pathInArchive);
                if (entry == null) {
                    throw new FileNotFoundException("Couldn't find " + pathInArchive + " in " + zipArchivePath);
                }
                in = zipFile.getInputStream(entry);
                t = processor.apply(in);
                if (in == null) break block15;
                in.close();
            }
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        throw new IOException("Failed to process file " + pathInArchive + " from " + zipArchivePath);
                    }
                }
            }
        }
    }

    public static void extractZip(ArchiveOperations archiveOperations, File input, final File output, final boolean overrideExisting, boolean clean, Action<? super PatternFilterable> filter, final Function<String, String> renamer, final GradleInternalUtils.ProgressLoggerWrapper loggerWrapper) throws IOException {
        FileTree tree = archiveOperations.zipTree((Object)input);
        FileTree filtered = tree.matching(filter);
        final HashSet extracted = Sets.newHashSet();
        HashSet current = Sets.newHashSet();
        Stream<Path> stream = Files.walk(output.toPath(), new FileVisitOption[0]);
        stream.forEach(path -> current.add(path.toFile()));
        stream.close();
        loggerWrapper.setSize(filtered.getFiles().size());
        loggerWrapper.started();
        filtered.visit(new org.gradle.api.file.FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                File dir = new File(output, dirDetails.getPath());
                dir.mkdirs();
            }

            public void visitFile(FileVisitDetails fileDetails) {
                loggerWrapper.incrementProcessedFileCount();
                File outputFile = new File(output, (String)renamer.apply(fileDetails.getPath()));
                extracted.add(outputFile);
                if (!overrideExisting && outputFile.exists()) {
                    return;
                }
                outputFile.getParentFile().mkdirs();
                try {
                    Files.copy(fileDetails.getFile().toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to copy file: " + fileDetails.getPath(), e);
                }
            }
        });
        if (clean) {
            Set<File> toDelete = current.stream().filter(file -> !extracted.contains(file)).collect(Collectors.toSet());
            toDelete.forEach(File::delete);
        }
        loggerWrapper.completed();
    }

    public static void addCsvToZip(String name, List<String[]> mappings, ZipOutputStream out) throws IOException {
        if (mappings.size() <= 1) {
            return;
        }
        out.putNextEntry(FileUtils.getStableEntry(name));
        try (CsvWriter writer = CsvWriter.builder().lineDelimiter(LineDelimiter.LF).build((Writer)new UncloseableOutputStreamWriter(out));){
            mappings.forEach(arg_0 -> ((CsvWriter)writer).writeRow(arg_0));
        }
        out.closeEntry();
    }

    public static ZipEntry getStableEntry(String name) {
        return FileUtils.getStableEntry(name, 628041600000L);
    }

    public static ZipEntry getStableEntry(String name, long time) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(time);
        TimeZone.setDefault(_default);
        return ret;
    }

    public static void delete(Path file) throws IOException {
        if (Files.isRegularFile(file, new LinkOption[0])) {
            Files.delete(file);
        }
        if (Files.isDirectory(file, new LinkOption[0])) {
            Files.walkFileTree(file, (FileVisitor<? super Path>)DeletingPathVisitor.withLongCounters());
            Files.deleteIfExists(file);
        }
    }

    public static String postFixClassifier(File file, String classifier) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name + "-" + classifier;
        }
        return name.substring(0, dotIndex) + "-" + classifier + name.substring(dotIndex);
    }

    public static boolean contains(File file, String shouldContain) {
        try {
            return new String(Files.readAllBytes(file.toPath())).contains(shouldContain);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static class UncloseableOutputStreamWriter
    extends OutputStreamWriter {
        private UncloseableOutputStreamWriter(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            super.flush();
        }
    }
}

