/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXmlStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter backing;
    private final String indent;
    private int indentLevel;
    private boolean inTag;

    public IndentingXmlStreamWriter(XMLStreamWriter backing, String indent) {
        this.backing = backing;
        this.indent = indent;
    }

    private void newline() throws XMLStreamException {
        this.backing.writeCharacters("\n");
    }

    private void unwindIndent() throws XMLStreamException {
        if (this.inTag) {
            this.inTag = false;
            this.newline();
            for (int i = 0; i < this.indentLevel; ++i) {
                this.backing.writeCharacters(this.indent);
            }
        }
    }

    private void handleStart() throws XMLStreamException {
        this.unwindIndent();
        this.inTag = true;
        ++this.indentLevel;
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.handleStart();
        this.backing.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.handleStart();
        this.backing.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.handleStart();
        this.backing.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.unwindIndent();
        this.inTag = true;
        this.backing.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.unwindIndent();
        this.inTag = true;
        this.backing.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.unwindIndent();
        this.inTag = true;
        this.backing.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.inTag = true;
        --this.indentLevel;
        this.unwindIndent();
        this.inTag = true;
        this.backing.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.newline();
        this.backing.writeEndDocument();
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.backing.writeStartDocument();
        this.inTag = true;
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.backing.writeStartDocument(version);
        this.inTag = true;
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.backing.writeStartDocument(encoding, version);
        this.inTag = true;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeEntityRef(name);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.unwindIndent();
        this.backing.writeCharacters(text, start, len);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.backing.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.backing.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.backing.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.backing.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.backing.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.backing.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.backing.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.backing.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.backing.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.backing.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.backing.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        this.backing.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.backing.flush();
    }
}

