/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;

public class ZipBuildingFileTreeVisitor
implements FileVisitor {
    protected final ZipOutputStream outputZipStream;

    public ZipBuildingFileTreeVisitor(ZipOutputStream outputZipStream) {
        this.outputZipStream = outputZipStream;
    }

    public void visitDir(FileVisitDetails fileVisitDetails) {
        block2: {
            try {
                ZipEntry directoryEntry = new ZipEntry(fileVisitDetails.getRelativePath().getPathString() + "/");
                this.outputZipStream.putNextEntry(directoryEntry);
                this.outputZipStream.closeEntry();
            }
            catch (IOException zip) {
                if (zip.getMessage().equals("duplicate entry: " + fileVisitDetails.getRelativePath().getPathString() + "/")) break block2;
                throw new RuntimeException("Could not create zip directory: " + fileVisitDetails.getRelativePath().getPathString(), zip);
            }
        }
    }

    public void visitFile(FileVisitDetails fileVisitDetails) {
        try {
            ZipEntry fileEntry = new ZipEntry(fileVisitDetails.getRelativePath().getPathString());
            this.outputZipStream.putNextEntry(fileEntry);
            fileVisitDetails.copyTo((OutputStream)this.outputZipStream);
            this.outputZipStream.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create zip file: " + fileVisitDetails.getRelativePath().getPathString(), e);
        }
    }
}

