/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.specification;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.dsl.userdev.runtime.specification.UserDevSpecification;
import net.neoforged.gradle.userdev.runtime.extension.UserDevRuntimeExtension;
import net.neoforged.gradle.util.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserDevRuntimeSpecification
extends CommonRuntimeSpecification
implements UserDevSpecification {
    private final FileTree userDevArchive;
    private final String forgeGroup;
    private final String forgeName;
    private final String forgeVersion;
    private final UserdevProfile profile;
    private final Artifact userDevArtifact;
    @Nullable
    private String minecraftVersion = null;

    public UserDevRuntimeSpecification(Project project, String version, FileTree userDevArchive, UserdevProfile profile, DistributionType distribution, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, String forgeGroup, String forgeName, String forgeVersion, Artifact artifact) {
        super(project, "neoForge", version, distribution, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, UserDevRuntimeExtension.class);
        this.userDevArchive = userDevArchive;
        this.profile = profile;
        this.forgeGroup = forgeGroup;
        this.forgeName = forgeName;
        this.forgeVersion = forgeVersion;
        this.userDevArtifact = artifact;
    }

    @NotNull
    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public FileTree getUserDevArchive() {
        return this.userDevArchive;
    }

    public String getForgeGroup() {
        return this.forgeGroup;
    }

    public String getForgeName() {
        return this.forgeName;
    }

    public UserdevProfile getProfile() {
        return this.profile;
    }

    public Artifact getUserDevArtifact() {
        return this.userDevArtifact;
    }

    @NotNull
    public String getMinecraftVersion() {
        return Objects.requireNonNull(this.minecraftVersion, "Minecraft version not set");
    }

    public void setMinecraftVersion(@NotNull String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDevRuntimeSpecification that = (UserDevRuntimeSpecification)((Object)o);
        return Objects.equals(this.forgeGroup, that.forgeGroup) && Objects.equals(this.forgeName, that.forgeName) && Objects.equals(this.forgeVersion, that.forgeVersion) && Objects.equals(this.minecraftVersion, that.minecraftVersion);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.forgeGroup, this.forgeName, this.forgeVersion, this.minecraftVersion);
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<UserDevRuntimeSpecification, Builder>
    implements UserDevSpecification.Builder<UserDevRuntimeSpecification, Builder> {
        private Provider<String> forgeVersionProvider;
        private Provider<String> forgeGroupProvider;
        private Provider<String> forgeNameProvider;

        private Builder(Project project) {
            super(project);
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        public Builder withForgeVersion(Provider<String> forgeVersion) {
            this.forgeVersionProvider = forgeVersion;
            return this;
        }

        public Builder withForgeVersion(String forgeVersion) {
            if (forgeVersion == null) {
                return this;
            }
            return this.withForgeVersion(this.project.provider(() -> forgeVersion));
        }

        public Builder withForgeName(Provider<String> mcpName) {
            this.forgeNameProvider = mcpName;
            return this;
        }

        public Builder withForgeName(String mcpName) {
            if (mcpName == null) {
                return this;
            }
            return this.withForgeName(this.project.provider(() -> mcpName));
        }

        public Builder withForgeGroup(Provider<String> mcpGroup) {
            this.forgeGroupProvider = mcpGroup;
            return this;
        }

        public Builder withForgeGroup(String mcpGroup) {
            if (mcpGroup == null) {
                return this;
            }
            return this.withForgeGroup(this.project.provider(() -> mcpGroup));
        }

        @NotNull
        public UserDevRuntimeSpecification build() {
            UserdevProfile profile;
            String group = (String)this.forgeGroupProvider.get();
            String name = (String)this.forgeNameProvider.get();
            String version = (String)this.forgeVersionProvider.get();
            Artifact artifact = new Artifact(group, name, version, "userdev", "jar");
            ResolvedArtifact userdevArchiveArtifact = ToolUtilities.resolveToolArtifact((Project)this.project, (String)artifact.getDescriptor());
            File userdevArchive = userdevArchiveArtifact.getFile();
            ModuleVersionIdentifier effectiveVersion = userdevArchiveArtifact.getModuleVersion().getId();
            try {
                profile = (UserdevProfile)FileUtils.processFileFromZip((File)userdevArchive, (String)"config.json", in -> UserdevProfile.get((ObjectFactory)this.project.getObjects(), (InputStream)in));
            }
            catch (IOException e) {
                throw new GradleException("Failed to read userdev config file for version " + String.valueOf(effectiveVersion), (Throwable)e);
            }
            return new UserDevRuntimeSpecification(this.project, effectiveVersion.getVersion(), this.project.zipTree((Object)userdevArchive), profile, (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, effectiveVersion.getGroup(), effectiveVersion.getName(), effectiveVersion.getVersion(), artifact);
        }
    }
}

