/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.extension;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.tasks.StripFinalFromParametersTask;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.JavaSourceTransformAdapterUtils;
import net.neoforged.gradle.common.util.ListUtils;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.run.TypesUtil;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Decompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.InputFileSpecification;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.dsl.neoform.configuration.NeoFormConfigConfigurationSpecV1;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.InjectZipContent;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserDevRuntimeExtension
extends CommonRuntimeExtension<UserDevRuntimeSpecification, UserDevRuntimeSpecification.Builder, UserDevRuntimeDefinition> {
    @Inject
    public UserDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected UserDevRuntimeDefinition doCreate(UserDevRuntimeSpecification spec) {
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        Decompiler decompilerSubsystemConfiguration = ((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getDecompiler();
        Minecraft minecraftExtension = (Minecraft)this.getProject().getExtensions().getByType(Minecraft.class);
        UserdevProfile userDevProfile = spec.getProfile();
        FileTree userDevJar = spec.getUserDevArchive();
        Configuration userDevAdditionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (String)("AdditionalDependenciesFor" + spec.getIdentifier()), (Dependency[])new Dependency[0]);
        if (this.useCombinedJarWithNeoForgeOnRecompile(userDevProfile)) {
            userDevAdditionalDependenciesConfiguration.getDependencies().addLater(userDevProfile.getUniversalJarArtifactCoordinate().map(arg_0 -> ((DependencyHandler)spec.getProject().getDependencies()).create(arg_0)));
        }
        for (String dependencyCoordinate : (List)userDevProfile.getAdditionalDependencyArtifactCoordinates().get()) {
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)dependencyCoordinate));
        }
        if (!userDevProfile.getNeoForm().isPresent()) {
            throw new IllegalStateException("Userdev configuration spec has no MCP version. As of now this is not supported!");
        }
        NeoFormRuntimeDefinition neoFormRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.maybeCreate(builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withNeoFormDependency(userDevProfile.getNeoForm().get()).withDistributionType(DistributionType.JOINED)).withAdditionalDependencies((FileCollection)this.getProject().files(new Object[]{userDevAdditionalDependenciesConfiguration})).withStepsMutator(this.adaptNeoFormRuntime(spec, userDevProfile, userDevJar));
            FileTree accessTransformerFiles = userDevJar.matching(filter -> filter.include(new String[]{(String)userDevProfile.getAccessTransformerDirectory().get() + "/**"}));
            builder.withPreTaskAdapter("recompile", JavaSourceTransformAdapterUtils.createCustomizationsAdapter((Project)this.getProject(), (FileCollection)accessTransformerFiles));
            builder.withPostTaskAdapter("patch", this.createPatchAdapter(userDevJar, (String)userDevProfile.getSourcePatchesDirectory().get()));
            if (!this.useCombinedJarWithNeoForgeOnRecompile(userDevProfile)) {
                builder.withTaskCustomizer("inject", InjectZipContent.class, task -> {
                    ConfigurableFileTree injectionDirectoryTree = userDevProfile.getInjectedFilesDirectory().isPresent() ? this.getProject().fileTree((Object)new File((String)userDevProfile.getInjectedFilesDirectory().get())) : null;
                    this.configureNeoforgeInjects((InjectZipContent)task, (FileTree)injectionDirectoryTree, (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeSourceLookupFor" + spec.getIdentifier()), (Provider)userDevProfile.getSourcesJarArtifactCoordinate()), (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeRawLookupFor" + spec.getIdentifier()), (Provider)userDevProfile.getUniversalJarArtifactCoordinate()));
                });
            } else if (((Boolean)decompilerSubsystemConfiguration.getIsDisabled().get()).booleanValue()) {
                builder.withPostTaskAdapter("downloadClient", new TaskTreeAdapter(){

                    @NotNull
                    public TaskProvider<? extends Runtime> adapt(Definition<?> definition, Provider<? extends WithOutput> previousTasksOutput, File runtimeWorkspace, Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifacts, Map<String, String> mappingVersionData, Consumer<TaskProvider<? extends Runtime>> dependentTaskConfigurationHandler) {
                        TaskProvider stripper = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"stripClientFinals"), StripFinalFromParametersTask.class, task -> task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
                        dependentTaskConfigurationHandler.accept((TaskProvider<? extends Runtime>)stripper);
                        return stripper;
                    }
                });
                builder.withPostTaskAdapter("downloadServer", new TaskTreeAdapter(){

                    @NotNull
                    public TaskProvider<? extends Runtime> adapt(Definition<?> definition, Provider<? extends WithOutput> previousTasksOutput, File runtimeWorkspace, Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifacts, Map<String, String> mappingVersionData, Consumer<TaskProvider<? extends Runtime>> dependentTaskConfigurationHandler) {
                        TaskProvider stripper = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"stripServerFinals"), StripFinalFromParametersTask.class, task -> task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
                        dependentTaskConfigurationHandler.accept((TaskProvider<? extends Runtime>)stripper);
                        return stripper;
                    }
                });
                builder.withPostTaskAdapter("setup", (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
                    AccessTransformers userAts = minecraftExtension.getAccessTransformers();
                    if (userAts.getFiles().isEmpty()) {
                        return null;
                    }
                    TaskProvider task = CommonRuntimeTaskUtils.createBinaryAccessTransformer((Definition)definition, (String)"", (FileTree)userAts.getFiles().getAsFileTree());
                    task.configure(t -> {
                        t.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
                        t.dependsOn(new Object[]{previousTasksOutput});
                    });
                    dependentTaskConfigurationHandler.accept(task);
                    return task;
                });
            }
        });
        spec.setMinecraftVersion(((NeoFormRuntimeSpecification)neoFormRuntimeDefinition.getSpecification()).getMinecraftVersion());
        if (!this.useCombinedJarWithNeoForgeOnRecompile(userDevProfile)) {
            Dependency clientExtraJar = spec.getProject().getDependencies().create((Object)ExtraJarDependencyManager.generateClientCoordinateFor((String)spec.getMinecraftVersion()));
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)clientExtraJar);
        }
        return new UserDevRuntimeDefinition(spec, neoFormRuntimeDefinition, userDevJar, userDevProfile, userDevAdditionalDependenciesConfiguration);
    }

    @NotNull
    private BiConsumer<List<NeoFormConfigConfigurationSpecV1.Step>, Map<String, NeoFormConfigConfigurationSpecV1.Function>> adaptNeoFormRuntime(UserDevRuntimeSpecification spec, UserdevProfile userDevProfile, FileTree userDevJar) {
        return (steps, functions) -> {
            if (!this.useCombinedJarWithNeoForgeOnRecompile(userDevProfile)) {
                return;
            }
            steps.removeIf(step -> step.getType().equals("strip"));
            steps.removeIf(step -> step.getType().equals("merge"));
            steps.removeIf(step -> step.getType().equals("mergeMappings"));
            steps.removeIf(step -> step.getType().equals("rename"));
            int decompileIndex = ListUtils.removeIfAndReturnIndex((List)steps, step -> step.getType().equals("decompile"));
            steps.add(decompileIndex, new NeoFormConfigConfigurationSpecV1.Step("decompile", "decompile", Map.of("libraries", "{listLibrariesOutput}", "input", "{setupOutput}")));
            Subsystems subsystems = (Subsystems)spec.getProject().getExtensions().getByType(Subsystems.class);
            SetupConfiguration configuration = this.buildSetupConfiguration(userDevProfile, userDevJar);
            functions.put("setup", new NeoFormConfigConfigurationSpecV1.Function((String)subsystems.getTools().getInstallerTools().get(), configuration.arguments()));
            steps.add(decompileIndex, new NeoFormConfigConfigurationSpecV1.Step("setup", "setup", configuration.values()));
        };
    }

    private SetupConfiguration buildSetupConfiguration(UserdevProfile userDevProfile, FileTree userDevJar) {
        Decompiler decompilerSubsystemConfiguration = ((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getDecompiler();
        if (((Boolean)decompilerSubsystemConfiguration.getIsDisabled().get()).booleanValue() && this.useCombinedJarWithNeoForgeOnRecompile(userDevProfile)) {
            return new SetupConfiguration(List.of("--task", "PROCESS_MINECRAFT_JAR", "--input", "{client}", "--input", "{server}", "--output", "{output}", "--input-mappings", "{clientMappings}", "--neoform-data", "{neoform}", "--apply-patches", "{patches}"), Map.of("client", "{downloadClientOutput}", "clientMappings", "{downloadClientMappingsOutput}", "server", "{downloadServerOutput}", "neoform", "{neoform}", "patches", ((File)userDevProfile.getBinaryPatchFile().map(patchFilePath -> userDevJar.matching(matcher -> matcher.include(new String[]{patchFilePath})).getSingleFile()).get()).getAbsolutePath()));
        }
        return new SetupConfiguration(List.of("--task", "PROCESS_MINECRAFT_JAR", "--input", "{client}", "--input", "{server}", "--output", "{output}", "--input-mappings", "{clientMappings}", "--neoform-data", "{neoform}"), Map.of("client", "{downloadClientOutput}", "clientMappings", "{downloadClientMappingsOutput}", "server", "{downloadServerOutput}", "neoform", "{neoform}"));
    }

    private boolean useCombinedJarWithNeoForgeOnRecompile(UserdevProfile userDevProfile) {
        return (Boolean)userDevProfile.getFeatures().flatMap(UserdevProfile.Features::getUsesCombinedBinaryPatches).getOrElse((Object)false);
    }

    protected void afterRegistration(UserDevRuntimeDefinition runtime) {
        RunTypeManager runTypes = (RunTypeManager)this.getProject().getExtensions().getByType(RunTypeManager.class);
        runtime.getUserdevConfiguration().getRunTypes().forEach(type -> TypesUtil.registerWithPotentialPrefix((NamedDomainObjectContainer)runTypes, (String)((UserDevRuntimeSpecification)runtime.getSpecification()).getIdentifier(), (String)type.getName(), arg_0 -> ((RunType)type).copyTo(arg_0)));
        Conventions conventions = ((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getConventions();
        if (((Boolean)conventions.getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getShouldDefaultRunsBeCreated().get()).booleanValue()) {
            RunManager runs = (RunManager)this.getProject().getExtensions().getByType(RunManager.class);
            runtime.getUserdevConfiguration().getRunTypes().forEach(runType -> {
                if (runs.getNames().contains(runType.getName())) {
                    return;
                }
                try {
                    runs.create(runType.getName());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        ProjectUtils.afterEvaluate((Project)this.getProject(), () -> this.bakeDefinition(runtime));
    }

    private void bakeDefinition(UserDevRuntimeDefinition definition) {
        Decompiler decompilerSubsystemConfiguration = ((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getDecompiler();
        if (((Boolean)decompilerSubsystemConfiguration.getIsDisabled().get()).booleanValue() && this.useCombinedJarWithNeoForgeOnRecompile(definition.getUserdevConfiguration())) {
            definition.getNeoFormRuntimeDefinition().getRawJarTask().configure(task -> ((InputFileSpecification)task).getInput().set(definition.getNeoFormRuntimeDefinition().getTask("setup").flatMap(OutputSpecification::getOutput)));
        }
    }

    protected UserDevRuntimeSpecification.Builder createBuilder() {
        return UserDevRuntimeSpecification.Builder.from(this.getProject());
    }

    private TaskTreeAdapter createPatchAdapter(FileTree userDevArchive, String patchDirectory) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"patchUserDev"), Patch.class, task -> {
            task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.getPatchArchive().from(new Object[]{userDevArchive});
            task.getPatchDirectory().set((Object)patchDirectory);
        });
    }

    private void configureNeoforgeInjects(InjectZipContent task, @Nullable FileTree userDevInjectDir, Provider<File> sourcesInjectArtifact, Provider<File> resourcesInjectArtifact) {
        if (userDevInjectDir != null) {
            task.injectFileTree(userDevInjectDir);
        }
        if (sourcesInjectArtifact.isPresent()) {
            task.injectZip(sourcesInjectArtifact, filter -> filter.include(new String[]{"net/**"}));
        }
        if (resourcesInjectArtifact.isPresent()) {
            task.injectZip(resourcesInjectArtifact, filter -> {
                filter.exclude(new String[]{"**/*.class"});
                filter.exclude(new String[]{"META-INF/**/*.DSA"});
                filter.exclude(new String[]{"**/*.SF"});
            });
        }
    }

    private record SetupConfiguration(List<String> arguments, Map<String, String> values) {
    }
}

