/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.DependencyCollectorInjector;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.userdev.dependency.UserDevAdditionalTestDependenciesParser;
import net.neoforged.gradle.userdev.dependency.UserDevReplacementResult;
import net.neoforged.gradle.userdev.dependency.UserDevRunTypeParser;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.extension.UserDevRuntimeExtension;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyCollector;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;

public final class UserDevDependencyManager {
    private static final UserDevDependencyManager INSTANCE = new UserDevDependencyManager();

    public static UserDevDependencyManager getInstance() {
        return INSTANCE;
    }

    private UserDevDependencyManager() {
    }

    public void apply(Project project) {
        this.registerReplacementHandler(project);
        this.registerRunTypeParser(project);
        this.registerUnitTestDependencyMapping(project);
    }

    private void registerUnitTestDependencyMapping(Project project) {
        RunManager runs = (RunManager)project.getExtensions().getByType(RunManager.class);
        runs.configureAll(run -> run.getUnitTestSources().whenSourceSetAdded(sourceSet -> {
            Configuration implementation = SourceSetUtils.getProject((SourceSet)sourceSet).getConfigurations().getByName(sourceSet.getImplementationConfigurationName());
            UserDevAdditionalTestDependenciesParser parser = new UserDevAdditionalTestDependenciesParser(project);
            implementation.getDependencies().addAllLater(TransformerUtils.ifTrue((Provider)run.getIsJUnit(), (Provider)run.getSdkClasspathElements().map(files -> files.stream().map(FileSystemLocation::getAsFile).map(parser::parse).collect(Collectors.toList())).flatMap(TransformerUtils.combineAllLists((Project)project, String.class, Function.identity())).map(dependencyCoordinates -> {
                DependencyCollectorInjector injector = (DependencyCollectorInjector)project.getObjects().newInstance(DependencyCollectorInjector.class, new Object[0]);
                DependencyCollector collector = injector.dependencyCollector();
                dependencyCoordinates.forEach(arg_0 -> ((DependencyCollector)collector).add(arg_0));
                return collector;
            }).flatMap(DependencyCollector::getDependencies)));
        }));
    }

    private void registerRunTypeParser(Project project) {
        RunTypeManager runTypes = (RunTypeManager)project.getExtensions().getByType(RunTypeManager.class);
        runTypes.registerParser((RunTypeManager.Parser)new UserDevRunTypeParser(project));
    }

    private void registerReplacementHandler(Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("neoForge", dependencyReplacementHandler -> dependencyReplacementHandler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            ModuleDependency patt4195$temp = context.getDependency();
            if (!(patt4195$temp instanceof ExternalModuleDependency)) {
                return Optional.empty();
            }
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)patt4195$temp;
            UserDevRuntimeDefinition runtimeDefinition = UserDevDependencyManager.buildForgeUserDevRuntimeFrom(project, externalModuleDependency);
            Configuration additionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)project, (String)("NeoForgeUserDevAdditionalReplacementDependenciesFor" + ((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier()), configuration -> {
                configuration.setDescription("Additional dependencies for the NeoForge UserDev replacement for " + ((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier());
                ConfigurationUtils.extendsFrom((Project)project, (Configuration)configuration, (Configuration[])new Configuration[]{runtimeDefinition.getNeoFormRuntimeDefinition().getMinecraftDependenciesConfiguration()});
                ConfigurationUtils.extendsFrom((Project)project, (Configuration)configuration, (Configuration[])new Configuration[]{runtimeDefinition.getAdditionalUserDevDependencies()});
            });
            return Optional.of(new UserDevReplacementResult(project, (TaskProvider<? extends WithOutput>)runtimeDefinition.getNeoFormRuntimeDefinition().getSourceJarTask(), (TaskProvider<? extends WithOutput>)runtimeDefinition.getNeoFormRuntimeDefinition().getRawJarTask(), ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)project.getConfigurations(), (String)("NeoForgeUserDevMdkFor" + ((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier()), (Dependency[])new Dependency[]{((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getUserDevArtifact().toDependency(project)}), additionalDependenciesConfiguration, Collections.emptySet(), runtimeDefinition));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraftforge") && !externalModuleDependency.getGroup().equals("net.neoforged") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("forge") || dependency.getName().equals("neoforge");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return UserDevDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "sources") && Objects.equals(artifact.getExtension(), "jar");
    }

    private static UserDevRuntimeDefinition buildForgeUserDevRuntimeFrom(Project project, ExternalModuleDependency dependency) {
        UserDevRuntimeExtension forgeRuntimeExtension = (UserDevRuntimeExtension)((Object)project.getExtensions().getByType(UserDevRuntimeExtension.class));
        return (UserDevRuntimeDefinition)forgeRuntimeExtension.maybeCreateFor((Dependency)dependency, builder -> {
            ExternalModuleDependency clone = dependency.copy();
            clone.artifact(artifact -> {
                artifact.setExtension("jar");
                artifact.setClassifier("userdev");
            });
            Configuration userdevLookup = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)project.getConfigurations(), (String)"ResolveRequestedNeoForgeVersion", (Dependency[])new Dependency[]{clone});
            ResolvedArtifact resolvedArtifact = (ResolvedArtifact)((ResolvedDependency)userdevLookup.getResolvedConfiguration().getFirstLevelModuleDependencies().iterator().next()).getModuleArtifacts().iterator().next();
            builder.withForgeVersion(resolvedArtifact.getModuleVersion().getId().getVersion());
            builder.withForgeGroup(resolvedArtifact.getModuleVersion().getId().getGroup());
            builder.withForgeName(resolvedArtifact.getModuleVersion().getId().getName());
            builder.withDistributionType(DistributionType.JOINED);
        });
    }
}

