/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.Project;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class UserDevAdditionalTestDependenciesParser {
    final Project project;

    public UserDevAdditionalTestDependenciesParser(Project project) {
        this.project = project;
    }

    public Provider<List<String>> parse(File file) {
        if (!file.exists()) {
            return this.project.provider(Collections::emptyList);
        }
        try {
            return this.parseFileInternal(file);
        }
        catch (Exception e) {
            return this.project.provider(Collections::emptyList);
        }
    }

    private Provider<List<String>> parseFileInternal(File file) {
        FileTree fileTree = file.getName().endsWith(".jar") || file.getName().endsWith(".zip") ? this.project.zipTree((Object)file) : this.project.fileTree((Object)file);
        Provider providers = fileTree.matching(pattern -> pattern.include(new String[]{"config.json"})).getElements().map(fls -> fls.stream().map(FileSystemLocation::getAsFile).filter(File::isFile).collect(Collectors.toList())).map(files -> files.stream().map(this::parseInternalFile).collect(Collectors.toList()));
        return providers.flatMap(TransformerUtils.combineAllLists((Project)this.project, String.class, Function.identity()));
    }

    private Provider<List<String>> parseInternalFile(File file) {
        ListProperty listProperty;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            listProperty = UserdevProfile.get((ObjectFactory)this.project.getObjects(), (InputStream)inputStream).getAdditionalTestDependencyArtifactCoordinates();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return this.project.provider(Collections::emptyList);
            }
        }
        inputStream.close();
        return listProperty;
    }
}

