/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.specification;

import com.google.common.collect.Multimap;
import java.util.Objects;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.extension.UserDev;
import net.neoforged.gradle.dsl.userdev.runtime.specification.UserDevSpecification;
import net.neoforged.gradle.userdev.runtime.extension.UserDevRuntimeExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserDevRuntimeSpecification
extends CommonRuntimeSpecification
implements UserDevSpecification {
    private final String forgeGroup;
    private final String forgeName;
    private final String forgeVersion;
    @Nullable
    private String minecraftVersion = null;

    public UserDevRuntimeSpecification(Project project, String version, DistributionType distribution, Multimap<String, TaskTreeAdapter> preTaskTypeAdapters, Multimap<String, TaskTreeAdapter> postTypeAdapters, Multimap<String, TaskCustomizer<? extends Task>> taskCustomizers, String forgeGroup, String forgeName, String forgeVersion) {
        super(project, "neoForge", version, distribution, preTaskTypeAdapters, postTypeAdapters, taskCustomizers, UserDevRuntimeExtension.class);
        this.forgeGroup = forgeGroup;
        this.forgeName = forgeName;
        this.forgeVersion = forgeVersion;
    }

    @NotNull
    public String getForgeVersion() {
        return this.forgeVersion;
    }

    public String getForgeGroup() {
        return this.forgeGroup;
    }

    public String getForgeName() {
        return this.forgeName;
    }

    @NotNull
    public String getMinecraftVersion() {
        return Objects.requireNonNull(this.minecraftVersion, "Minecraft version not set");
    }

    public void setMinecraftVersion(@NotNull String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDevRuntimeSpecification that = (UserDevRuntimeSpecification)((Object)o);
        return Objects.equals(this.forgeGroup, that.forgeGroup) && Objects.equals(this.forgeName, that.forgeName) && Objects.equals(this.forgeVersion, that.forgeVersion) && Objects.equals(this.minecraftVersion, that.minecraftVersion);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.forgeGroup, this.forgeName, this.forgeVersion, this.minecraftVersion);
    }

    public static final class Builder
    extends CommonRuntimeSpecification.Builder<UserDevRuntimeSpecification, Builder>
    implements UserDevSpecification.Builder<UserDevRuntimeSpecification, Builder> {
        private boolean hasConfiguredForgeVersion;
        private boolean hasConfiguredForgeName;
        private boolean hasConfiguredForgeGroup;
        private Provider<String> forgeVersionProvider;
        private Provider<String> forgeGroupProvider;
        private Provider<String> forgeNameProvider;

        private Builder(Project project) {
            super(project);
        }

        protected Builder getThis() {
            return this;
        }

        public static Builder from(Project project) {
            return new Builder(project);
        }

        protected void configureBuilder() {
            super.configureBuilder();
            UserDev runtimeExtension = (UserDev)this.getProject().getExtensions().getByType(UserDev.class);
            if (!this.hasConfiguredForgeVersion) {
                this.forgeVersionProvider = runtimeExtension.getDefaultForgeVersion();
            }
            if (!this.hasConfiguredForgeGroup) {
                this.forgeGroupProvider = runtimeExtension.getDefaultForgeGroup();
            }
            if (!this.hasConfiguredForgeName) {
                this.forgeNameProvider = runtimeExtension.getDefaultForgeName();
            }
        }

        public Builder withForgeVersion(Provider<String> forgeVersion) {
            this.forgeVersionProvider = forgeVersion;
            this.hasConfiguredForgeVersion = true;
            return this;
        }

        public Builder withForgeVersion(String forgeVersion) {
            if (forgeVersion == null) {
                return this;
            }
            return this.withForgeVersion(this.project.provider(() -> forgeVersion));
        }

        public Builder withForgeName(Provider<String> mcpName) {
            this.forgeNameProvider = mcpName;
            this.hasConfiguredForgeName = true;
            return this;
        }

        public Builder withForgeName(String mcpName) {
            if (mcpName == null) {
                return this;
            }
            return this.withForgeName(this.project.provider(() -> mcpName));
        }

        public Builder withForgeGroup(Provider<String> mcpGroup) {
            this.forgeGroupProvider = mcpGroup;
            this.hasConfiguredForgeGroup = true;
            return this;
        }

        public Builder withForgeGroup(String mcpGroup) {
            if (mcpGroup == null) {
                return this;
            }
            return this.withForgeGroup(this.project.provider(() -> mcpGroup));
        }

        public UserDevRuntimeSpecification build() {
            String group = (String)this.forgeGroupProvider.get();
            String name = (String)this.forgeNameProvider.get();
            String version = (String)this.forgeVersionProvider.get();
            Artifact universalArtifact = new Artifact(group, name, version, "userdev", "jar");
            Artifact resolvedArtifact = Builder.resolveUserDevVersion(this.project, universalArtifact);
            return new UserDevRuntimeSpecification(this.project, resolvedArtifact.getVersion(), (DistributionType)this.distributionType.get(), (Multimap<String, TaskTreeAdapter>)this.preTaskAdapters, (Multimap<String, TaskTreeAdapter>)this.postTaskAdapters, (Multimap<String, TaskCustomizer<? extends Task>>)this.taskCustomizers, resolvedArtifact.getGroup(), resolvedArtifact.getName(), resolvedArtifact.getVersion());
        }

        private static Artifact resolveUserDevVersion(Project project, Artifact current) {
            if (!Objects.equals(current.getVersion(), "+")) {
                return current;
            }
            Configuration resolveConfig = ConfigurationUtils.temporaryConfiguration((Project)project, (Dependency[])new Dependency[]{current.toDependency(project)});
            return resolveConfig.getResolvedConfiguration().getResolvedArtifacts().stream().filter(current.asArtifactMatcher()).findFirst().map(Artifact::from).orElse(current);
        }
    }
}

