/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.extension;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.common.util.run.TypesUtil;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.Artifact;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.Download;
import net.neoforged.gradle.neoform.runtime.tasks.InjectCode;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.neoform.runtime.tasks.UnpackZip;
import net.neoforged.gradle.neoform.util.NeoFormAccessTransformerUtils;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class UserDevRuntimeExtension
extends CommonRuntimeExtension<UserDevRuntimeSpecification, UserDevRuntimeSpecification.Builder, UserDevRuntimeDefinition> {
    @Inject
    public UserDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected UserDevRuntimeDefinition doCreate(UserDevRuntimeSpecification spec) {
        UserdevProfile userDevConfigurationSpec;
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        Dependency userDevDependency = this.getProject().getDependencies().create((Object)String.format("%s:%s:%s:userdev", spec.getForgeGroup(), spec.getForgeName(), spec.getForgeVersion()));
        Configuration userDevConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (Dependency[])new Dependency[]{userDevDependency});
        ResolvedConfiguration resolvedUserDevConfiguration = userDevConfiguration.getResolvedConfiguration();
        File userDevJar = (File)resolvedUserDevConfiguration.getFiles().iterator().next();
        File forgeDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("neoForge/%s", spec.getIdentifier())).get()).getAsFile();
        File unpackedForgeDirectory = new File(forgeDirectory, "unpacked");
        unpackedForgeDirectory.mkdirs();
        FileTree userDevJarZipTree = spec.getProject().zipTree((Object)userDevJar);
        CopyingFileTreeVisitor unpackingVisitor = new CopyingFileTreeVisitor(unpackedForgeDirectory);
        userDevJarZipTree.visit((FileVisitor)unpackingVisitor);
        File userDevConfigFile = new File(unpackedForgeDirectory, "config.json");
        Gson userdevGson = UserdevProfile.createGson((ObjectFactory)this.getProject().getObjects());
        try {
            FileInputStream fileInputStream = new FileInputStream(userDevConfigFile);
            Object object = null;
            try {
                userDevConfigurationSpec = (UserdevProfile)userdevGson.fromJson((Reader)new InputStreamReader(fileInputStream), UserdevProfile.class);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fileInputStream != null) {
                    if (object != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Configuration userDevAdditionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (Dependency[])new Dependency[0]);
        for (String dependencyCoordinate : (List)userDevConfigurationSpec.getAdditionalDependencyArtifactCoordinates().get()) {
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)dependencyCoordinate));
        }
        if (!userDevConfigurationSpec.getNeoForm().isPresent()) {
            throw new IllegalStateException("Userdev configuration spec has no MCP version. As of now this is not supported!");
        }
        Artifact neoFormArtifact = Artifact.from((String)((String)userDevConfigurationSpec.getNeoForm().get()));
        NeoFormRuntimeDefinition mcpRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.maybeCreate(builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withNeoFormArtifact(neoFormArtifact).withDistributionType(DistributionType.JOINED)).withAdditionalDependencies((FileCollection)this.getProject().files(new Object[]{userDevAdditionalDependenciesConfiguration}));
            TaskTreeAdapter atAndSASAdapter = this.createAccessTransformerAdapter((String)userDevConfigurationSpec.getAccessTransformerDirectory().get(), unpackedForgeDirectory, this.getProject()).andThen(NeoFormAccessTransformerUtils.createAccessTransformerAdapter((Project)this.getProject()));
            builder.withPreTaskAdapter("decompile", atAndSASAdapter);
            TaskTreeAdapter patchAdapter = this.createPatchAdapter((String)userDevConfigurationSpec.getSourcePatchesDirectory().get(), unpackedForgeDirectory);
            Provider<TaskTreeAdapter> optionalInjectionAdapter = this.createInjectionAdapter((Provider<String>)userDevConfigurationSpec.getInjectedFilesDirectory(), unpackedForgeDirectory);
            TaskTreeAdapter resultingAdapter = (TaskTreeAdapter)optionalInjectionAdapter.map(inject -> inject.andThen(patchAdapter)).getOrElse((Object)patchAdapter);
            TaskTreeAdapter withForgeSourcesAdapter = (TaskTreeAdapter)userDevConfigurationSpec.getSourcesJarArtifactCoordinate().map(sources -> resultingAdapter.andThen(this.createInjectForgeSourcesAdapter((String)sources))).getOrElse((Object)resultingAdapter);
            TaskTreeAdapter withForgeResourcesAdapter = (TaskTreeAdapter)userDevConfigurationSpec.getUniversalJarArtifactCoordinate().map(resources -> withForgeSourcesAdapter.andThen(this.createInjectResourcesAdapter((String)resources))).getOrElse((Object)withForgeSourcesAdapter);
            builder.withPostTaskAdapter("patch", withForgeResourcesAdapter);
        });
        spec.setMinecraftVersion(((NeoFormRuntimeSpecification)mcpRuntimeDefinition.getSpecification()).getMinecraftVersion());
        this.getProject().getExtensions().configure("runTypes", types -> userDevConfigurationSpec.getRunTypes().forEach(type -> TypesUtil.registerWithPotentialPrefix((NamedDomainObjectContainer)types, (String)spec.getIdentifier(), (String)type.getName(), arg_0 -> ((RunType)type).copyTo(arg_0))));
        return new UserDevRuntimeDefinition(spec, mcpRuntimeDefinition, unpackedForgeDirectory, userDevConfigurationSpec, userDevAdditionalDependenciesConfiguration);
    }

    protected UserDevRuntimeSpecification.Builder createBuilder() {
        return UserDevRuntimeSpecification.Builder.from(this.getProject());
    }

    protected void bakeDefinition(UserDevRuntimeDefinition definition) {
        UserDevRuntimeSpecification spec = (UserDevRuntimeSpecification)definition.getSpecification();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        definition.onBake((NamingChannel)mappingsExtension.getChannel().get(), ((Directory)spec.getProject().getLayout().getBuildDirectory().get()).dir("userdev").dir(spec.getIdentifier()).getAsFile());
    }

    private TaskTreeAdapter createAccessTransformerAdapter(String accessTransformerDirectory, File unpackedForgeUserDevDirectory, Project project) {
        Set accessTransformerFiles = project.fileTree((Object)new File(unpackedForgeUserDevDirectory, accessTransformerDirectory)).getFiles();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createAccessTransformer((Definition)definition, (String)"Forges", (File)runtimeWorkspace, (Consumer)dependentTaskConfigurationHandler, (Iterable)accessTransformerFiles, Collections.emptyList());
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }

    private Provider<TaskTreeAdapter> createInjectionAdapter(Provider<String> injectionDirectory, File unpackedForgeUserDevDirectory) {
        return injectionDirectory.map(s -> {
            File directory = new File(unpackedForgeUserDevDirectory, (String)s);
            if (!directory.exists()) {
                return null;
            }
            return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"injectUserDev"), InjectCode.class, task -> {
                task.getInjectionSource().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
                task.getInjectionDirectory().fileValue(directory);
            });
        });
    }

    private TaskTreeAdapter createPatchAdapter(String patchDirectory, File unpackForgeUserDevDirectory) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"patchUserDev"), Patch.class, task -> {
            task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.getPatchDirectory().fileProvider(definition.getSpecification().getProject().provider(() -> new File(unpackForgeUserDevDirectory, patchDirectory)));
        });
    }

    private TaskTreeAdapter createInjectForgeSourcesAdapter(String forgeSourcesCoordinate) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            Configuration forgeSourcesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)definition.getSpecification().getProject(), (Dependency[])new Dependency[]{definition.getSpecification().getProject().getDependencies().create((Object)forgeSourcesCoordinate)});
            TaskProvider downloadForgeSources = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"downloadForgesSources"), Download.class, task -> task.getInput().from(new Object[]{forgeSourcesConfiguration}));
            dependentTaskConfigurationHandler.accept(downloadForgeSources);
            TaskProvider unzipForgeSources = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"unzipForgesSources"), UnpackZip.class, task -> {
                task.getInputZip().set(downloadForgeSources.flatMap(OutputSpecification::getOutput));
                task.dependsOn(new Object[]{downloadForgeSources});
            });
            dependentTaskConfigurationHandler.accept(unzipForgeSources);
            return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"injectForgesSources"), InjectCode.class, task -> {
                task.getInjectionSource().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
                task.getInjectionDirectory().set(unzipForgeSources.flatMap(UnpackZip::getUnpackingTarget));
                task.getInclusionFilter().add((Object)"net/**");
                task.dependsOn(new Object[]{unzipForgeSources});
            });
        };
    }

    private TaskTreeAdapter createInjectResourcesAdapter(String forgeUniversalCoordinate) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            Configuration forgeUniversalConfiguration = ConfigurationUtils.temporaryConfiguration((Project)definition.getSpecification().getProject(), (Dependency[])new Dependency[]{definition.getSpecification().getProject().getDependencies().create((Object)forgeUniversalCoordinate)});
            TaskProvider downloadForgeUniversal = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"downloadForgeUniversal"), Download.class, task -> task.getInput().from(new Object[]{forgeUniversalConfiguration}));
            dependentTaskConfigurationHandler.accept(downloadForgeUniversal);
            TaskProvider unzipForgeUniversal = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"unzipForgeUniversal"), UnpackZip.class, task -> {
                task.getInputZip().set(downloadForgeUniversal.flatMap(OutputSpecification::getOutput));
                task.dependsOn(new Object[]{downloadForgeUniversal});
            });
            dependentTaskConfigurationHandler.accept(unzipForgeUniversal);
            return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"injectForgeResources"), InjectCode.class, task -> {
                task.getInjectionSource().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
                task.getInjectionDirectory().set(unzipForgeUniversal.flatMap(UnpackZip::getUnpackingTarget));
                task.getExclusionFilter().add((Object)"**/*.class");
                task.getExclusionFilter().add((Object)"META-INF/**/*.DSA");
                task.getExclusionFilter().add((Object)"**/*.SF");
                task.dependsOn(new Object[]{unzipForgeUniversal});
            });
        };
    }
}

