/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import java.util.ArrayList;
import java.util.List;
import net.neoforged.gradle.dsl.userdev.dependency.DependencyFilter;
import net.neoforged.gradle.dsl.userdev.dependency.DependencyManagementObject;
import net.neoforged.gradle.userdev.dependency.AbstractDependencyManagementObject;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.specs.Spec;

public class DefaultDependencyFilter
extends AbstractDependencyManagementObject
implements DependencyFilter {
    protected final List<Spec<? super DependencyManagementObject.ArtifactIdentifier>> includeSpecs = new ArrayList<Spec<? super DependencyManagementObject.ArtifactIdentifier>>();
    protected final List<Spec<? super DependencyManagementObject.ArtifactIdentifier>> excludeSpecs = new ArrayList<Spec<? super DependencyManagementObject.ArtifactIdentifier>>();

    public DefaultDependencyFilter(Project project) {
        super(project);
    }

    public DependencyFilter exclude(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec) {
        this.excludeSpecs.add(spec);
        return this;
    }

    public DependencyFilter include(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec) {
        this.includeSpecs.add(spec);
        return this;
    }

    public boolean isIncluded(ResolvedDependency dependency) {
        return this.isIncluded(DefaultDependencyFilter.createArtifactIdentifier(dependency));
    }

    public boolean isIncluded(ModuleDependency dependency) {
        return this.isIncluded(DefaultDependencyFilter.createArtifactIdentifier(dependency));
    }

    public boolean isIncluded(DependencyManagementObject.ArtifactIdentifier dependency) {
        boolean include = this.includeSpecs.isEmpty() || this.includeSpecs.stream().anyMatch(spec -> spec.isSatisfiedBy((Object)dependency));
        boolean exclude = !this.excludeSpecs.isEmpty() && this.excludeSpecs.stream().anyMatch(spec -> spec.isSatisfiedBy((Object)dependency));
        return include && !exclude;
    }
}

