/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.extension;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.run.TypesUtil;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.RunSpecification;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runs.type.RunTypeManager;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.InjectZipContent;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.neoform.util.NeoFormAccessTaskAdapterUtils;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserDevRuntimeExtension
extends CommonRuntimeExtension<UserDevRuntimeSpecification, UserDevRuntimeSpecification.Builder, UserDevRuntimeDefinition> {
    @Inject
    public UserDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected UserDevRuntimeDefinition doCreate(UserDevRuntimeSpecification spec) {
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        UserdevProfile userDevProfile = spec.getProfile();
        FileTree userDevJar = spec.getUserDevArchive();
        Configuration userDevAdditionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (String)("AdditionalDependenciesFor" + spec.getIdentifier()), (Dependency[])new Dependency[0]);
        for (String dependencyCoordinate : (List)userDevProfile.getAdditionalDependencyArtifactCoordinates().get()) {
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)dependencyCoordinate));
        }
        if (!userDevProfile.getNeoForm().isPresent()) {
            throw new IllegalStateException("Userdev configuration spec has no MCP version. As of now this is not supported!");
        }
        NeoFormRuntimeDefinition neoFormRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.maybeCreate(builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withNeoFormDependency(userDevProfile.getNeoForm().get()).withDistributionType(DistributionType.JOINED)).withAdditionalDependencies((FileCollection)this.getProject().files(new Object[]{userDevAdditionalDependenciesConfiguration}));
            TaskTreeAdapter atAndIISAdapter = this.createAccessTransformerAdapter((String)userDevProfile.getAccessTransformerDirectory().get(), userDevJar).andThen(NeoFormAccessTaskAdapterUtils.createAccessTransformerAdapter((Project)this.getProject()));
            builder.withPostTaskAdapter("decompile", atAndIISAdapter);
            builder.withPreTaskAdapter("recompile", NeoFormAccessTaskAdapterUtils.createInterfaceInjectionAdapter((Project)this.getProject()));
            builder.withPostTaskAdapter("patch", this.createPatchAdapter(userDevJar, (String)userDevProfile.getSourcePatchesDirectory().get()));
            builder.withTaskCustomizer("inject", InjectZipContent.class, task -> {
                ConfigurableFileTree injectionDirectoryTree = userDevProfile.getInjectedFilesDirectory().isPresent() ? this.getProject().fileTree((Object)new File((String)userDevProfile.getInjectedFilesDirectory().get())) : null;
                this.configureNeoforgeInjects((InjectZipContent)task, (FileTree)injectionDirectoryTree, (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeSourceLookupFor" + spec.getIdentifier()), (Provider)userDevProfile.getSourcesJarArtifactCoordinate()), (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeRawLookupFor" + spec.getIdentifier()), (Provider)userDevProfile.getUniversalJarArtifactCoordinate()));
            });
        });
        spec.setMinecraftVersion(((NeoFormRuntimeSpecification)neoFormRuntimeDefinition.getSpecification()).getMinecraftVersion());
        return new UserDevRuntimeDefinition(spec, neoFormRuntimeDefinition, userDevJar, userDevProfile, userDevAdditionalDependenciesConfiguration);
    }

    protected void afterRegistration(UserDevRuntimeDefinition runtime) {
        RunTypeManager runTypes = (RunTypeManager)this.getProject().getExtensions().getByType(RunTypeManager.class);
        runtime.getUserdevConfiguration().getRunTypes().forEach(type -> TypesUtil.registerWithPotentialPrefix((NamedDomainObjectContainer)runTypes, (String)((UserDevRuntimeSpecification)runtime.getSpecification()).getIdentifier(), (String)type.getName(), arg_0 -> ((RunType)type).copyTo(arg_0)));
        Conventions conventions = ((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getConventions();
        if (((Boolean)conventions.getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getShouldDefaultRunsBeCreated().get()).booleanValue()) {
            RunManager runs = (RunManager)this.getProject().getExtensions().getByType(RunManager.class);
            runtime.getUserdevConfiguration().getRunTypes().forEach(runType -> {
                if (runs.getNames().contains(runType.getName())) {
                    return;
                }
                try {
                    Run run = (Run)runs.create(runType.getName());
                    run.configure((RunSpecification)runType);
                    run.getConfigureFromTypeWithName().set((Object)false);
                    run.getConfigureFromDependencies().set((Object)false);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
    }

    protected UserDevRuntimeSpecification.Builder createBuilder() {
        return UserDevRuntimeSpecification.Builder.from(this.getProject());
    }

    private TaskTreeAdapter createAccessTransformerAdapter(String accessTransformerDirectory, FileTree userDev) {
        FileTree accessTransformerFiles = userDev.matching(filter -> filter.include(new String[]{accessTransformerDirectory + "/**"}));
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            if (accessTransformerFiles.isEmpty()) {
                return null;
            }
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createSourceAccessTransformer((Definition)definition, (String)"Forges", (FileTree)accessTransformerFiles, (TaskProvider)definition.getListLibrariesTaskProvider(), (FileCollection)definition.getAllDependencies());
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }

    private TaskTreeAdapter createPatchAdapter(FileTree userDevArchive, String patchDirectory) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"patchUserDev"), Patch.class, task -> {
            task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.getPatchArchive().from(new Object[]{userDevArchive});
            task.getPatchDirectory().set((Object)patchDirectory);
        });
    }

    private void configureNeoforgeInjects(InjectZipContent task, @Nullable FileTree userDevInjectDir, Provider<File> sourcesInjectArtifact, Provider<File> resourcesInjectArtifact) {
        if (userDevInjectDir != null) {
            task.injectFileTree(userDevInjectDir);
        }
        if (sourcesInjectArtifact.isPresent()) {
            task.injectZip(sourcesInjectArtifact, filter -> filter.include(new String[]{"net/**"}));
        }
        if (resourcesInjectArtifact.isPresent()) {
            task.injectZip(resourcesInjectArtifact, filter -> {
                filter.exclude(new String[]{"**/*.class"});
                filter.exclude(new String[]{"META-INF/**/*.DSA"});
                filter.exclude(new String[]{"**/*.SF"});
            });
        }
    }
}

