/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.definition;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.definition.IDelegatingRuntimeDefinition;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.dsl.userdev.runtime.definition.UserDevDefinition;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import net.neoforged.gradle.userdev.runtime.tasks.ClasspathSerializer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class UserDevRuntimeDefinition
extends CommonRuntimeDefinition<UserDevRuntimeSpecification>
implements UserDevDefinition<UserDevRuntimeSpecification>,
IDelegatingRuntimeDefinition<UserDevRuntimeSpecification> {
    private final NeoFormRuntimeDefinition neoformRuntimeDefinition;
    private final FileTree unpackedUserDevJarDirectory;
    private final UserdevProfile userdevConfiguration;
    private final Configuration additionalUserDevDependencies;
    private TaskProvider<? extends WithOutput> userdevClasspathElementProducer;

    public UserDevRuntimeDefinition(@NotNull UserDevRuntimeSpecification specification, NeoFormRuntimeDefinition neoformRuntimeDefinition, FileTree unpackedUserDevJarDirectory, UserdevProfile userdevConfiguration, Configuration additionalUserDevDependencies) {
        super((CommonRuntimeSpecification)specification, neoformRuntimeDefinition.getTasks(), neoformRuntimeDefinition.getSourceJarTask(), neoformRuntimeDefinition.getRawJarTask(), neoformRuntimeDefinition.getGameArtifactProvidingTasks(), neoformRuntimeDefinition.getMinecraftDependenciesConfiguration(), arg_0 -> ((NeoFormRuntimeDefinition)neoformRuntimeDefinition).configureAssociatedTask(arg_0), neoformRuntimeDefinition.getVersionJson());
        this.neoformRuntimeDefinition = neoformRuntimeDefinition;
        this.unpackedUserDevJarDirectory = unpackedUserDevJarDirectory;
        this.userdevConfiguration = userdevConfiguration;
        this.additionalUserDevDependencies = additionalUserDevDependencies;
        Dependency clientExtraJar = ((UserDevRuntimeSpecification)this.getSpecification()).getProject().getDependencies().create((Object)ExtraJarDependencyManager.generateClientCoordinateFor((String)((UserDevRuntimeSpecification)this.getSpecification()).getMinecraftVersion()));
        this.additionalUserDevDependencies.getDependencies().add((Object)clientExtraJar);
        this.getAllDependencies().from(new Object[]{neoformRuntimeDefinition.getAllDependencies()});
        this.getAllDependencies().from(new Object[]{this.getAdditionalUserDevDependencies()});
        this.getAllDependencies().from(new Object[]{this.getUserdevConfiguration()});
    }

    public NeoFormRuntimeDefinition getNeoFormRuntimeDefinition() {
        return this.neoformRuntimeDefinition;
    }

    public FileTree getUnpackedUserDevJarDirectory() {
        return this.unpackedUserDevJarDirectory;
    }

    public UserdevProfile getUserdevConfiguration() {
        return this.userdevConfiguration;
    }

    public Configuration getAdditionalUserDevDependencies() {
        return this.additionalUserDevDependencies;
    }

    @NotNull
    public TaskProvider<DownloadAssets> getAssets() {
        return this.neoformRuntimeDefinition.getAssets();
    }

    @NotNull
    public TaskProvider<ExtractNatives> getNatives() {
        return this.neoformRuntimeDefinition.getNatives();
    }

    @NotNull
    public Map<String, String> getMappingVersionData() {
        return this.neoformRuntimeDefinition.getMappingVersionData();
    }

    @NotNull
    public TaskProvider<? extends WithOutput> getListLibrariesTaskProvider() {
        return this.neoformRuntimeDefinition.getListLibrariesTaskProvider();
    }

    protected void buildRunInterpolationData(RunImpl run, @NotNull MapProperty<String, String> interpolationData) {
        this.neoformRuntimeDefinition.buildRunInterpolationData(run, interpolationData);
        if (this.userdevConfiguration.getModules() != null && !((List)this.userdevConfiguration.getModules().get()).isEmpty()) {
            String name = String.format("moduleResolverForgeUserDev%s", ((UserDevRuntimeSpecification)this.getSpecification()).getVersionedName());
            Configuration modulesCfg = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)((UserDevRuntimeSpecification)this.getSpecification()).getProject().getConfigurations(), (String)String.format("moduleResolverForgeUserDev%s", ((UserDevRuntimeSpecification)this.getSpecification()).getVersionedName()), (Provider)this.userdevConfiguration.getModules().map(modules -> modules.stream().map(m -> ((UserDevRuntimeSpecification)this.getSpecification()).getProject().getDependencies().create(m)).collect(Collectors.toList())));
            interpolationData.put((Object)"modules", modulesCfg.getIncoming().getArtifacts().getResolvedArtifacts().map(artifacts -> artifacts.stream().map(ResolvedArtifactResult::getFile).map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator))));
        }
        TaskProvider minecraftClasspathSerializer = ((UserDevRuntimeSpecification)this.getSpecification()).getProject().getTasks().register(RunsUtil.createTaskName((String)"writeMinecraftClasspath", (Run)run), ClasspathSerializer.class, task -> {
            this.additionalUserDevDependencies.getExtendsFrom().forEach(arg_0 -> UserDevRuntimeDefinition.lambda$buildRunInterpolationData$3(task.getInputFiles(), arg_0));
            task.getInputFiles().from(new Object[]{this.additionalUserDevDependencies});
            task.getInputFiles().from(new Object[]{this.neoformRuntimeDefinition.getMinecraftDependenciesConfiguration()});
            task.getInputFiles().from(new Object[]{this.userdevClasspathElementProducer.flatMap(OutputSpecification::getOutput)});
            task.getInputFiles().from(new Object[]{run.getDependencies().getRuntimeConfiguration()});
        });
        this.configureAssociatedTask(minecraftClasspathSerializer);
        interpolationData.put((Object)"minecraft_classpath_file", minecraftClasspathSerializer.flatMap(ClasspathSerializer::getTargetFile).map(RegularFile::getAsFile).map(File::getAbsolutePath));
        run.getPostSyncTasks().add((Provider)minecraftClasspathSerializer);
    }

    public Definition<?> getDelegate() {
        return this.neoformRuntimeDefinition;
    }

    public TaskProvider<? extends WithOutput> getUserdevClasspathElementProducer() {
        return this.userdevClasspathElementProducer;
    }

    public void setUserdevClasspathElementProducer(TaskProvider<? extends WithOutput> userdevClasspathElementProducer) {
        this.userdevClasspathElementProducer = userdevClasspathElementProducer;
    }

    private static /* synthetic */ void lambda$buildRunInterpolationData$3(ConfigurableFileCollection rec$, Object xva$0) {
        rec$.from(new Object[]{xva$0});
    }
}

