/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.extension;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.run.TypesUtil;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.InjectZipContent;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.neoform.util.NeoFormAccessTransformerUtils;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyCollector;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserDevRuntimeExtension
extends CommonRuntimeExtension<UserDevRuntimeSpecification, UserDevRuntimeSpecification.Builder, UserDevRuntimeDefinition> {
    @Inject
    public UserDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected UserDevRuntimeDefinition doCreate(UserDevRuntimeSpecification spec) {
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        UserdevProfile userdevProfile = spec.getProfile();
        FileTree userDevJar = spec.getUserDevArchive();
        Configuration userDevAdditionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (String)("AdditionalDependenciesFor" + spec.getIdentifier()), (Dependency[])new Dependency[0]);
        for (String dependencyCoordinate : (List)userdevProfile.getAdditionalDependencyArtifactCoordinates().get()) {
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)dependencyCoordinate));
        }
        if (!userdevProfile.getNeoForm().isPresent()) {
            throw new IllegalStateException("Userdev configuration spec has no MCP version. As of now this is not supported!");
        }
        NeoFormRuntimeDefinition mcpRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.maybeCreate(builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withNeoFormDependency(userdevProfile.getNeoForm().get()).withDistributionType(DistributionType.JOINED)).withAdditionalDependencies((FileCollection)this.getProject().files(new Object[]{userDevAdditionalDependenciesConfiguration}));
            TaskTreeAdapter atAdapter = this.createAccessTransformerAdapter((String)userdevProfile.getAccessTransformerDirectory().get(), userDevJar).andThen(NeoFormAccessTransformerUtils.createAccessTransformerAdapter((Project)this.getProject()));
            builder.withPostTaskAdapter("decompile", atAdapter);
            builder.withPostTaskAdapter("patch", this.createPatchAdapter(userDevJar, (String)userdevProfile.getSourcePatchesDirectory().get()));
            builder.withTaskCustomizer("inject", InjectZipContent.class, task -> {
                ConfigurableFileTree injectionDirectoryTree = userdevProfile.getInjectedFilesDirectory().isPresent() ? this.getProject().fileTree((Object)new File((String)userdevProfile.getInjectedFilesDirectory().get())) : null;
                this.configureNeoforgeInjects((InjectZipContent)task, (FileTree)injectionDirectoryTree, (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeSourceLookupFor" + spec.getIdentifier()), (Provider)userdevProfile.getSourcesJarArtifactCoordinate()), (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (String)("NeoForgeRawLookupFor" + spec.getIdentifier()), (Provider)userdevProfile.getUniversalJarArtifactCoordinate()));
            });
        });
        spec.setMinecraftVersion(((NeoFormRuntimeSpecification)mcpRuntimeDefinition.getSpecification()).getMinecraftVersion());
        NamedDomainObjectContainer runs = (NamedDomainObjectContainer)this.getProject().getExtensions().getByName("runs");
        ProjectUtils.afterEvaluate((Project)spec.getProject(), () -> runs.stream().filter(run -> (Boolean)run.getIsJUnit().get()).flatMap(run -> ((List)run.getUnitTestSources().get()).stream()).distinct().forEach(src -> {
            DependencyCollector coll = spec.getProject().getObjects().dependencyCollector();
            ((List)spec.getProfile().getAdditionalTestDependencyArtifactCoordinates().get()).forEach(arg_0 -> ((DependencyCollector)coll).add(arg_0));
            spec.getProject().getConfigurations().getByName(src.getImplementationConfigurationName()).fromDependencyCollector(coll);
        }));
        NamedDomainObjectContainer runTypes = (NamedDomainObjectContainer)this.getProject().getExtensions().getByName("runTypes");
        userdevProfile.getRunTypes().forEach(type -> TypesUtil.registerWithPotentialPrefix((NamedDomainObjectContainer)runTypes, (String)spec.getIdentifier(), (String)type.getName(), arg_0 -> ((RunType)type).copyTo(arg_0)));
        return new UserDevRuntimeDefinition(spec, mcpRuntimeDefinition, userDevJar, userdevProfile, userDevAdditionalDependenciesConfiguration);
    }

    protected UserDevRuntimeSpecification.Builder createBuilder() {
        return UserDevRuntimeSpecification.Builder.from(this.getProject());
    }

    private TaskTreeAdapter createAccessTransformerAdapter(String accessTransformerDirectory, FileTree userDev) {
        FileTree accessTransformerFiles = userDev.matching(filter -> filter.include(new String[]{accessTransformerDirectory + "/**"}));
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createSourceAccessTransformer((Definition)definition, (String)"Forges", (File)runtimeWorkspace, (Consumer)dependentTaskConfigurationHandler, (FileTree)accessTransformerFiles, Collections.emptyList(), (TaskProvider)definition.getListLibrariesTaskProvider());
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }

    private TaskTreeAdapter createPatchAdapter(FileTree userDevArchive, String patchDirectory) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"patchUserDev"), Patch.class, task -> {
            task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.getPatchArchive().from(new Object[]{userDevArchive});
            task.getPatchDirectory().set((Object)patchDirectory);
        });
    }

    private void configureNeoforgeInjects(InjectZipContent task, @Nullable FileTree userDevInjectDir, Provider<File> sourcesInjectArtifact, Provider<File> resourcesInjectArtifact) {
        if (userDevInjectDir != null) {
            task.injectFileTree(userDevInjectDir);
        }
        if (sourcesInjectArtifact.isPresent()) {
            task.injectZip(sourcesInjectArtifact, filter -> filter.include(new String[]{"net/**"}));
        }
        if (resourcesInjectArtifact.isPresent()) {
            task.injectZip(resourcesInjectArtifact, filter -> {
                filter.exclude(new String[]{"**/*.class"});
                filter.exclude(new String[]{"META-INF/**/*.DSA"});
                filter.exclude(new String[]{"**/*.SF"});
            });
        }
    }
}

