/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.userdev.dependency.UserDevReplacementResult;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.extension.UserDevRuntimeExtension;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.TaskProvider;

public final class UserDevDependencyManager {
    private static final UserDevDependencyManager INSTANCE = new UserDevDependencyManager();

    public static UserDevDependencyManager getInstance() {
        return INSTANCE;
    }

    private UserDevDependencyManager() {
    }

    public void apply(Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("neoForge", dependencyReplacementHandler -> dependencyReplacementHandler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            if (!(context.getDependency() instanceof ExternalModuleDependency)) {
                return Optional.empty();
            }
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)context.getDependency();
            UserDevRuntimeDefinition runtimeDefinition = UserDevDependencyManager.buildForgeUserDevRuntimeFrom(project, externalModuleDependency);
            Configuration additionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)project, (String)("NeoForgeUserDevAdditionalReplacementDependenciesFor" + ((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier()), configuration -> {
                configuration.setDescription("Additional dependencies for the NeoForge UserDev replacement for " + ((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getIdentifier());
                configuration.extendsFrom(new Configuration[]{runtimeDefinition.getNeoFormRuntimeDefinition().getMinecraftDependenciesConfiguration()});
                configuration.extendsFrom(new Configuration[]{runtimeDefinition.getAdditionalUserDevDependencies()});
            });
            return Optional.of(new UserDevReplacementResult(project, (TaskProvider<? extends WithOutput>)runtimeDefinition.getNeoFormRuntimeDefinition().getSourceJarTask(), (TaskProvider<? extends WithOutput>)runtimeDefinition.getNeoFormRuntimeDefinition().getRawJarTask(), additionalDependenciesConfiguration, Collections.emptySet(), runtimeDefinition));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraftforge") && !externalModuleDependency.getGroup().equals("net.neoforged") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("forge") || dependency.getName().equals("neoforge");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return UserDevDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "sources") && Objects.equals(artifact.getExtension(), "jar");
    }

    private static UserDevRuntimeDefinition buildForgeUserDevRuntimeFrom(Project project, ExternalModuleDependency dependency) {
        UserDevRuntimeExtension forgeRuntimeExtension = (UserDevRuntimeExtension)((Object)project.getExtensions().getByType(UserDevRuntimeExtension.class));
        return (UserDevRuntimeDefinition)forgeRuntimeExtension.maybeCreateFor((Dependency)dependency, builder -> {
            ExternalModuleDependency clone = dependency.copy();
            clone.artifact(artifact -> {
                artifact.setExtension("jar");
                artifact.setClassifier("userdev");
            });
            Configuration userdevLookup = ConfigurationUtils.temporaryUnhandledConfiguration((ConfigurationContainer)project.getConfigurations(), (String)"ResolveRequestedNeoForgeVersion", (Dependency[])new Dependency[]{clone});
            ResolvedArtifact resolvedArtifact = (ResolvedArtifact)((ResolvedDependency)userdevLookup.getResolvedConfiguration().getFirstLevelModuleDependencies().iterator().next()).getModuleArtifacts().iterator().next();
            builder.withForgeVersion(resolvedArtifact.getModuleVersion().getId().getVersion());
            builder.withForgeGroup(resolvedArtifact.getModuleVersion().getId().getGroup());
            builder.withForgeName(resolvedArtifact.getModuleVersion().getId().getName());
            builder.withDistributionType(DistributionType.JOINED);
        });
    }
}

