/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.extension;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.extensions.CommonRuntimeExtension;
import net.neoforged.gradle.common.util.CommonRuntimeTaskUtils;
import net.neoforged.gradle.common.util.run.TypesUtil;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.neoform.runtime.extensions.NeoFormRuntimeExtension;
import net.neoforged.gradle.neoform.runtime.specification.NeoFormRuntimeSpecification;
import net.neoforged.gradle.neoform.runtime.tasks.InjectZipContent;
import net.neoforged.gradle.neoform.runtime.tasks.Patch;
import net.neoforged.gradle.neoform.util.NeoFormAccessTransformerUtils;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class UserDevRuntimeExtension
extends CommonRuntimeExtension<UserDevRuntimeSpecification, UserDevRuntimeSpecification.Builder, UserDevRuntimeDefinition> {
    @Inject
    public UserDevRuntimeExtension(Project project) {
        super(project);
    }

    @NotNull
    protected UserDevRuntimeDefinition doCreate(UserDevRuntimeSpecification spec) {
        NeoFormRuntimeExtension neoFormRuntimeExtension = (NeoFormRuntimeExtension)this.getProject().getExtensions().getByType(NeoFormRuntimeExtension.class);
        UserdevProfile userdevProfile = spec.getProfile();
        File userDevJar = spec.getUserDevArchive();
        File forgeDirectory = ((Directory)spec.getProject().getLayout().getBuildDirectory().dir(String.format("neoForge/%s", spec.getIdentifier())).get()).getAsFile();
        File unpackedForgeDirectory = new File(forgeDirectory, "unpacked");
        unpackedForgeDirectory.mkdirs();
        FileTree userDevJarZipTree = spec.getProject().zipTree((Object)userDevJar);
        CopyingFileTreeVisitor unpackingVisitor = new CopyingFileTreeVisitor(unpackedForgeDirectory);
        userDevJarZipTree.visit((FileVisitor)unpackingVisitor);
        Configuration userDevAdditionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.getProject(), (Dependency[])new Dependency[0]);
        for (String dependencyCoordinate : (List)userdevProfile.getAdditionalDependencyArtifactCoordinates().get()) {
            userDevAdditionalDependenciesConfiguration.getDependencies().add((Object)this.getProject().getDependencies().create((Object)dependencyCoordinate));
        }
        if (!userdevProfile.getNeoForm().isPresent()) {
            throw new IllegalStateException("Userdev configuration spec has no MCP version. As of now this is not supported!");
        }
        NeoFormRuntimeDefinition mcpRuntimeDefinition = (NeoFormRuntimeDefinition)neoFormRuntimeExtension.maybeCreate(builder -> {
            ((NeoFormRuntimeSpecification.Builder)builder.withNeoFormDependency(userdevProfile.getNeoForm().get()).withDistributionType(DistributionType.JOINED)).withAdditionalDependencies((FileCollection)this.getProject().files(new Object[]{userDevAdditionalDependenciesConfiguration}));
            TaskTreeAdapter atAndSASAdapter = this.createAccessTransformerAdapter((String)userdevProfile.getAccessTransformerDirectory().get(), unpackedForgeDirectory, this.getProject()).andThen(NeoFormAccessTransformerUtils.createAccessTransformerAdapter((Project)this.getProject()));
            builder.withPreTaskAdapter("decompile", atAndSASAdapter);
            builder.withPostTaskAdapter("patch", this.createPatchAdapter(userDevJar, (String)userdevProfile.getSourcePatchesDirectory().get()));
            builder.withTaskCustomizer("inject", InjectZipContent.class, task -> this.configureNeoforgeInjects((InjectZipContent)task, (Provider<File>)userdevProfile.getInjectedFilesDirectory().map(injectedDir -> new File(unpackedForgeDirectory, (String)injectedDir)), (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (Provider)userdevProfile.getSourcesJarArtifactCoordinate()), (Provider<File>)ConfigurationUtils.getArtifactProvider((Project)this.getProject(), (Provider)userdevProfile.getUniversalJarArtifactCoordinate())));
        });
        spec.setMinecraftVersion(((NeoFormRuntimeSpecification)mcpRuntimeDefinition.getSpecification()).getMinecraftVersion());
        this.getProject().getExtensions().configure("runTypes", types -> userdevProfile.getRunTypes().forEach(type -> TypesUtil.registerWithPotentialPrefix((NamedDomainObjectContainer)types, (String)spec.getIdentifier(), (String)type.getName(), arg_0 -> ((RunType)type).copyTo(arg_0))));
        return new UserDevRuntimeDefinition(spec, mcpRuntimeDefinition, unpackedForgeDirectory, userdevProfile, userDevAdditionalDependenciesConfiguration);
    }

    protected UserDevRuntimeSpecification.Builder createBuilder() {
        return UserDevRuntimeSpecification.Builder.from(this.getProject());
    }

    protected void bakeDefinition(UserDevRuntimeDefinition definition) {
        UserDevRuntimeSpecification spec = (UserDevRuntimeSpecification)definition.getSpecification();
        Minecraft minecraftExtension = (Minecraft)spec.getProject().getExtensions().getByType(Minecraft.class);
        Mappings mappingsExtension = minecraftExtension.getMappings();
        definition.onBake((NamingChannel)mappingsExtension.getChannel().get(), ((Directory)spec.getProject().getLayout().getBuildDirectory().get()).dir("userdev").dir(spec.getIdentifier()).getAsFile());
    }

    private TaskTreeAdapter createAccessTransformerAdapter(String accessTransformerDirectory, File unpackedForgeUserDevDirectory, Project project) {
        Set accessTransformerFiles = project.fileTree((Object)new File(unpackedForgeUserDevDirectory, accessTransformerDirectory)).getFiles();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            TaskProvider accessTransformerTask = CommonRuntimeTaskUtils.createAccessTransformer((Definition)definition, (String)"Forges", (File)runtimeWorkspace, (Consumer)dependentTaskConfigurationHandler, (Iterable)accessTransformerFiles, Collections.emptyList());
            accessTransformerTask.configure(task -> task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput)));
            accessTransformerTask.configure(task -> task.dependsOn(new Object[]{previousTasksOutput}));
            return accessTransformerTask;
        };
    }

    private TaskTreeAdapter createPatchAdapter(File userDevArchive, String patchDirectory) {
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"patchUserDev"), Patch.class, task -> {
            task.getInput().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.getPatchArchive().set(userDevArchive);
            task.getPatchDirectory().set((Object)patchDirectory);
        });
    }

    private void configureNeoforgeInjects(InjectZipContent task, Provider<File> userDevInjectDir, Provider<File> sourcesInjectArtifact, Provider<File> resourcesInjectArtifact) {
        if (userDevInjectDir.isPresent()) {
            task.injectDirectory(userDevInjectDir);
        }
        if (sourcesInjectArtifact.isPresent()) {
            task.injectZip(sourcesInjectArtifact, filter -> filter.include(new String[]{"net/**"}));
        }
        if (resourcesInjectArtifact.isPresent()) {
            task.injectZip(resourcesInjectArtifact, filter -> {
                filter.exclude(new String[]{"**/*.class"});
                filter.exclude(new String[]{"META-INF/**/*.DSA"});
                filter.exclude(new String[]{"**/*.SF"});
            });
        }
    }
}

