/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.runtime.definition;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.definition.IDelegatingRuntimeDefinition;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.userdev.configurations.UserdevProfile;
import net.neoforged.gradle.dsl.userdev.runtime.definition.UserDevDefinition;
import net.neoforged.gradle.neoform.runtime.definition.NeoFormRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import net.neoforged.gradle.userdev.runtime.tasks.ClasspathSerializer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class UserDevRuntimeDefinition
extends CommonRuntimeDefinition<UserDevRuntimeSpecification>
implements UserDevDefinition<UserDevRuntimeSpecification>,
IDelegatingRuntimeDefinition<UserDevRuntimeSpecification> {
    private final NeoFormRuntimeDefinition neoformRuntimeDefinition;
    private final File unpackedUserDevJarDirectory;
    private final UserdevProfile userdevConfiguration;
    private final Configuration additionalUserDevDependencies;
    private final List<TaskProvider<ClasspathSerializer>> classpathSerializers = new ArrayList<TaskProvider<ClasspathSerializer>>();
    private TaskProvider<? extends WithOutput> repoWritingTask = null;

    public UserDevRuntimeDefinition(@NotNull UserDevRuntimeSpecification specification, NeoFormRuntimeDefinition neoformRuntimeDefinition, File unpackedUserDevJarDirectory, UserdevProfile userdevConfiguration, Configuration additionalUserDevDependencies) {
        super((CommonRuntimeSpecification)specification, neoformRuntimeDefinition.getTasks(), neoformRuntimeDefinition.getSourceJarTask(), neoformRuntimeDefinition.getRawJarTask(), neoformRuntimeDefinition.getGameArtifactProvidingTasks(), neoformRuntimeDefinition.getMinecraftDependenciesConfiguration(), arg_0 -> ((NeoFormRuntimeDefinition)neoformRuntimeDefinition).configureAssociatedTask(arg_0), neoformRuntimeDefinition.getVersionJson());
        this.neoformRuntimeDefinition = neoformRuntimeDefinition;
        this.unpackedUserDevJarDirectory = unpackedUserDevJarDirectory;
        this.userdevConfiguration = userdevConfiguration;
        this.additionalUserDevDependencies = additionalUserDevDependencies;
        this.additionalUserDevDependencies.getDependencies().add((Object)((UserDevRuntimeSpecification)this.getSpecification()).getProject().getDependencies().create((Object)ExtraJarDependencyManager.generateClientCoordinateFor((String)((UserDevRuntimeSpecification)this.getSpecification()).getMinecraftVersion())));
    }

    public NeoFormRuntimeDefinition getNeoFormRuntimeDefinition() {
        return this.neoformRuntimeDefinition;
    }

    public File getUnpackedUserDevJarDirectory() {
        return this.unpackedUserDevJarDirectory;
    }

    public UserdevProfile getUserdevConfiguration() {
        return this.userdevConfiguration;
    }

    public Configuration getAdditionalUserDevDependencies() {
        return this.additionalUserDevDependencies;
    }

    public void setReplacedDependency(@NotNull Dependency dependency) {
        super.setReplacedDependency(dependency);
        this.neoformRuntimeDefinition.setReplacedDependency(dependency);
    }

    public void onRepoWritten(@NotNull TaskProvider<? extends WithOutput> finalRepoWritingTask) {
        this.neoformRuntimeDefinition.onRepoWritten(finalRepoWritingTask);
        this.classpathSerializers.forEach(taskProvider -> taskProvider.configure(task -> task.getInputFiles().from(new Object[]{finalRepoWritingTask})));
        this.classpathSerializers.clear();
        this.repoWritingTask = finalRepoWritingTask;
    }

    @NotNull
    public TaskProvider<DownloadAssets> getAssets() {
        return this.neoformRuntimeDefinition.getAssets();
    }

    @NotNull
    public TaskProvider<ExtractNatives> getNatives() {
        return this.neoformRuntimeDefinition.getNatives();
    }

    @NotNull
    public Map<String, String> getMappingVersionData() {
        return this.neoformRuntimeDefinition.getMappingVersionData();
    }

    @NotNull
    public TaskProvider<? extends WithOutput> getListLibrariesTaskProvider() {
        return this.neoformRuntimeDefinition.getListLibrariesTaskProvider();
    }

    protected Map<String, String> buildRunInterpolationData(RunImpl run) {
        Map interpolationData = this.neoformRuntimeDefinition.buildRunInterpolationData(run);
        if (this.userdevConfiguration.getModules() != null && !((List)this.userdevConfiguration.getModules().get()).isEmpty()) {
            Configuration modulesCfg;
            String name = String.format("moduleResolverForgeUserDev%s", ((UserDevRuntimeSpecification)this.getSpecification()).getVersionedName());
            if (((UserDevRuntimeSpecification)this.getSpecification()).getProject().getConfigurations().getNames().contains(name)) {
                modulesCfg = ((UserDevRuntimeSpecification)this.getSpecification()).getProject().getConfigurations().getByName(name);
            } else {
                modulesCfg = (Configuration)((UserDevRuntimeSpecification)this.getSpecification()).getProject().getConfigurations().create(name);
                modulesCfg.setCanBeResolved(true);
                ((List)this.userdevConfiguration.getModules().get()).forEach(m -> modulesCfg.getDependencies().add((Object)((UserDevRuntimeSpecification)this.getSpecification()).getProject().getDependencies().create(m)));
            }
            interpolationData.put("modules", modulesCfg.resolve().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        }
        TaskProvider minecraftClasspathSerializer = ((UserDevRuntimeSpecification)this.getSpecification()).getProject().getTasks().register(RunsUtil.createTaskName((String)"writeMinecraftClasspath", (Run)run), ClasspathSerializer.class, task -> {
            this.additionalUserDevDependencies.getExtendsFrom().forEach(arg_0 -> UserDevRuntimeDefinition.lambda$null$3(task.getInputFiles(), arg_0));
            task.getInputFiles().from(new Object[]{this.additionalUserDevDependencies});
            task.getInputFiles().from(new Object[]{this.neoformRuntimeDefinition.getMinecraftDependenciesConfiguration()});
            Configuration userDependencies = ((DependencyHandler)run.getDependencies().get()).getConfiguration();
            userDependencies.getExtendsFrom().forEach(arg_0 -> UserDevRuntimeDefinition.lambda$null$4(task.getInputFiles(), arg_0));
            task.getInputFiles().from(new Object[]{userDependencies});
        });
        this.configureAssociatedTask(minecraftClasspathSerializer);
        interpolationData.put("minecraft_classpath_file", ((RegularFile)((ClasspathSerializer)((Object)minecraftClasspathSerializer.get())).getOutput().get()).getAsFile().getAbsolutePath());
        run.dependsOn(new TaskProvider[]{minecraftClasspathSerializer});
        if (this.repoWritingTask == null) {
            this.classpathSerializers.add((TaskProvider<ClasspathSerializer>)minecraftClasspathSerializer);
        } else {
            minecraftClasspathSerializer.configure(task -> task.getInputFiles().from(new Object[]{this.repoWritingTask}));
        }
        return interpolationData;
    }

    public Definition<?> getDelegate() {
        return this.neoformRuntimeDefinition;
    }

    @NotNull
    public VersionJson getVersionJson() {
        return this.getNeoFormRuntimeDefinition().getVersionJson();
    }

    private static /* synthetic */ void lambda$null$4(ConfigurableFileCollection rec$, Object xva$0) {
        rec$.from(new Object[]{xva$0});
    }

    private static /* synthetic */ void lambda$null$3(ConfigurableFileCollection rec$, Object xva$0) {
        rec$.from(new Object[]{xva$0});
    }
}

