/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.userdev.dependency;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Optional;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementResult;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.userdev.extension.UserDev;
import net.neoforged.gradle.userdev.runtime.definition.UserDevRuntimeDefinition;
import net.neoforged.gradle.userdev.runtime.extension.UserDevRuntimeExtension;
import net.neoforged.gradle.userdev.runtime.specification.UserDevRuntimeSpecification;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.provider.Provider;

public final class UserDevDependencyManager {
    private static final UserDevDependencyManager INSTANCE = new UserDevDependencyManager();

    public static UserDevDependencyManager getInstance() {
        return INSTANCE;
    }

    private UserDevDependencyManager() {
    }

    public void apply(Project project) {
        DependencyReplacement dependencyReplacer = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacer.getReplacementHandlers().create("neoForge", dependencyReplacementHandler -> dependencyReplacementHandler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            if (!(context.getDependency() instanceof ExternalModuleDependency)) {
                return Optional.empty();
            }
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)context.getDependency();
            UserDevRuntimeDefinition runtimeDefinition = UserDevDependencyManager.buildForgeUserDevRuntimeFrom(project, externalModuleDependency);
            Configuration additionalDependenciesConfiguration = ConfigurationUtils.temporaryConfiguration((Project)project, (Dependency[])new Dependency[0]);
            additionalDependenciesConfiguration.extendsFrom(new Configuration[]{runtimeDefinition.getNeoFormRuntimeDefinition().getMinecraftDependenciesConfiguration()});
            additionalDependenciesConfiguration.extendsFrom(new Configuration[]{runtimeDefinition.getAdditionalUserDevDependencies()});
            return Optional.of(new DependencyReplacementResult(project, Optional.of(ConfigurationUtils.findReplacementConfigurations((Project)project, (Configuration)context.getConfiguration())), name -> CommonRuntimeUtils.buildTaskName((Definition)runtimeDefinition.getNeoFormRuntimeDefinition(), (String)name), runtimeDefinition.getNeoFormRuntimeDefinition().getSourceJarTask(), runtimeDefinition.getNeoFormRuntimeDefinition().getRawJarTask(), additionalDependenciesConfiguration, builder -> builder.setVersion(((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getForgeVersion()), builder -> builder.setVersion(((UserDevRuntimeSpecification)runtimeDefinition.getSpecification()).getForgeVersion()), runtimeDefinition::setReplacedDependency, runtimeDefinition::onRepoWritten, Sets::newHashSet));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraftforge") && !externalModuleDependency.getGroup().equals("net.neoforged") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("forge") || dependency.getName().equals("neoforge");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().isEmpty()) {
            return true;
        }
        return UserDevDependencyManager.hasSourcesArtifact(externalModuleDependency);
    }

    private static boolean hasSourcesArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "sources") && Objects.equals(artifact.getExtension(), "jar");
    }

    private static UserDevRuntimeDefinition buildForgeUserDevRuntimeFrom(Project project, ExternalModuleDependency dependency) {
        UserDevRuntimeExtension forgeRuntimeExtension = (UserDevRuntimeExtension)((Object)project.getExtensions().getByType(UserDevRuntimeExtension.class));
        UserDev userDevExtension = (UserDev)project.getExtensions().getByType(UserDev.class);
        return (UserDevRuntimeDefinition)forgeRuntimeExtension.maybeCreate(builder -> {
            Provider version = project.provider(() -> ((ExternalModuleDependency)dependency).getVersion()).orElse((Provider)userDevExtension.getDefaultForgeVersion());
            Provider group = project.provider(() -> ((ExternalModuleDependency)dependency).getGroup()).orElse((Provider)userDevExtension.getDefaultForgeGroup());
            Provider name = project.provider(() -> ((ExternalModuleDependency)dependency).getName()).orElse((Provider)userDevExtension.getDefaultForgeName());
            builder.withForgeVersion(version);
            builder.withForgeGroup(group);
            builder.withForgeName(name);
            builder.withDistributionType(DistributionType.JOINED);
        });
    }
}

