/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import java.util.Map;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.platform.tasks.TokenizedTask;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.bundling.Zip;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class CreateLegacyInstaller
extends Zip
implements WithOutput,
WithWorkspace,
TokenizedTask {
    public CreateLegacyInstaller() {
        this.getArchiveClassifier().convention((Object)"installer-unsigned");
        this.getArchiveExtension().convention((Object)"jar");
        this.getDestinationDirectory().convention(this.getLayout().getBuildDirectory().dir("libs"));
        this.getArchiveFileName().convention((Object)String.format("%s-%s-installer-unsigned.jar", this.getProject().getName(), this.getProject().getVersion()));
        this.getOutput().set(this.getArchiveFile());
        this.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        Object[] objectArray = new Object[1];
        objectArray[0] = this.getInstallerCore().map(arg_0 -> ((ArchiveOperations)this.getArchiveOperations()).zipTree(arg_0));
        this.from(objectArray);
        this.from(new Object[]{this.getLauncherJson()});
        this.from(new Object[]{this.getInstallerJson()});
        this.from(new Object[]{this.getUrlIcon()});
        this.exclude(new String[]{"big_logo.png"});
        this.from(this.getInstallerLogo(), spec -> spec.rename(original -> "big_logo.png"));
        this.from(this.getUnixServerArgs(), spec -> spec.rename(name -> "data/unix_args.txt"));
        this.from(this.getWindowsServerArgs(), spec -> spec.rename(name -> "data/win_args.txt"));
        this.from(this.getClientBinaryPatches(), spec -> {
            spec.into((Object)"data");
            spec.rename(name -> "client.lzma");
        });
        this.from(this.getServerBinaryPatches(), spec -> {
            spec.into((Object)"data");
            spec.rename(name -> "server.lzma");
        });
        this.getUrlIcon().fileValue(this.getProject().getRootProject().file((Object)"src/main/resources/url.png"));
        this.getInstallerLogo().fileValue(this.getProject().getRootProject().file((Object)"src/main/resources/neoforged_logo.png"));
        this.from(this.getData(), spec -> {
            spec.into((Object)"data");
            spec.filter(s -> {
                Map tokens = (Map)this.getTokens().get();
                for (Map.Entry entry : tokens.entrySet()) {
                    s = s.replace(String.format("@%s@", entry.getKey()), entry.getValue().toString());
                }
                return s;
            });
        });
    }

    @Inject
    @NotNull
    public abstract ObjectFactory getObjectFactory();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInstallerCore();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getClientBinaryPatches();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServerBinaryPatches();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLauncherJson();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInstallerJson();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getUrlIcon();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInstallerLogo();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getUnixServerArgs();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getWindowsServerArgs();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getData();
}

