/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import java.io.File;
import net.neoforged.gradle.dsl.common.tasks.WithOperations;
import net.neoforged.gradle.platform.util.SetupUtils;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class SetupProjectFromRuntime
extends DefaultTask
implements WithOperations {
    public SetupProjectFromRuntime() {
        this.setGroup("setup");
        File defaultSourceTarget = SetupUtils.getSetupSourceTarget(this.getProject());
        File defaultResourceTarget = SetupUtils.getSetupResourcesTarget(this.getProject());
        this.getSourcesDirectory().convention(this.getProject().getLayout().dir(this.getProviderFactory().provider(() -> defaultSourceTarget)));
        this.getResourcesDirectory().convention(this.getProject().getLayout().dir(this.getProviderFactory().provider(() -> defaultResourceTarget)));
        this.getShouldLockDirectories().convention((Object)true);
    }

    @TaskAction
    public void doSetup() throws Exception {
        File sourceFile = ((RegularFile)this.getSourcesFile().get()).getAsFile();
        FileTree jarFileTree = this.getArchiveOperations().zipTree((Object)sourceFile);
        FileTree codeFiles = jarFileTree.matching(filter -> filter.include(new String[]{"**/**.java"}));
        FileTree noneCodeFiles = jarFileTree.matching(filter -> filter.exclude(new String[]{"**/**.java"}));
        File sourceDirectory = ((Directory)this.getSourcesDirectory().get()).getAsFile();
        File resourcesDirectory = ((Directory)this.getResourcesDirectory().get()).getAsFile();
        sourceDirectory.setWritable(true);
        resourcesDirectory.setWritable(true);
        codeFiles.visit((FileVisitor)new CopyingFileTreeVisitor(sourceDirectory, false));
        noneCodeFiles.visit((FileVisitor)new CopyingFileTreeVisitor(resourcesDirectory, false));
        if (((Boolean)this.getShouldLockDirectories().get()).booleanValue()) {
            sourceDirectory.setReadOnly();
            resourcesDirectory.setReadOnly();
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getSourcesFile();

    @OutputDirectory
    public abstract DirectoryProperty getSourcesDirectory();

    @OutputDirectory
    public abstract DirectoryProperty getResourcesDirectory();

    @Input
    @Optional
    public abstract Property<Boolean> getShouldLockDirectories();
}

