/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LogLevel;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ApplyPatches
extends DefaultRuntime
implements WithWorkspace,
WithOutput {
    public ApplyPatches() {
        this.getPatchesPrefix().convention((Object)"");
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
        this.getShouldFailOnPatchFailure().convention((Object)false);
        this.getPatchMode().convention(this.getShouldFailOnPatchFailure().map(fail -> fail != false ? PatchMode.ACCESS : PatchMode.FUZZY));
    }

    @TaskAction
    public void doTask() throws Exception {
        if (!this.getPatches().isPresent()) {
            FileUtils.copyFile((File)((File)this.getBase().getAsFile().get()), (File)((RegularFile)this.getOutput().get()).getAsFile());
            return;
        }
        Path outputPath = this.ensureFileWorkspaceReady(this.getOutput()).toPath();
        Directory rejectsDir = (Directory)this.getRejects().get();
        Path rejectsPath = rejectsDir.getAsFile().toPath();
        PatchOperation.Builder builder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), org.gradle.api.logging.LogLevel.LIFECYCLE)).basePath(((RegularFile)this.getBase().get()).getAsFile().toPath()).patchesPath(((Directory)this.getPatches().get()).getAsFile().toPath()).outputPath(outputPath, ArchiveFormat.findFormat((Path)outputPath.getFileName())).rejectsPath(rejectsPath, ArchiveFormat.findFormat((Path)rejectsPath.getFileName())).mode((PatchMode)this.getPatchMode().get()).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).level((Boolean)this.getShouldFailOnPatchFailure().get() != false ? LogLevel.WARN : LogLevel.ALL).patchesPrefix((String)this.getPatchesPrefix().get());
        if (this.getMinimalFuzzingQuality().isPresent()) {
            builder.minFuzz(((Float)this.getMinimalFuzzingQuality().get()).floatValue());
        }
        if (this.getMaximalFuzzingOffset().isPresent()) {
            builder.maxOffset(((Integer)this.getMaximalFuzzingOffset().get()).intValue());
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
        if (exit != 0 && ((Boolean)this.getShouldFailOnPatchFailure().get()).booleanValue()) {
            throw new RuntimeException("Patches failed to apply.");
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getBase();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getPatches();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getRejects();

    @Input
    @Optional
    public abstract Property<ArchiveFormat> getRejectsFormat();

    @Input
    @Optional
    public abstract Property<PatchMode> getPatchMode();

    @Input
    @Optional
    public abstract Property<String> getPatchesPrefix();

    @Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @Input
    @Optional
    public abstract Property<Float> getMinimalFuzzingQuality();

    @Input
    @Optional
    public abstract Property<Integer> getMaximalFuzzingOffset();

    @Input
    @Optional
    public abstract Property<Boolean> getShouldFailOnPatchFailure();
}

