/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.util;

import java.io.File;
import net.neoforged.gradle.dsl.platform.util.ModuleIdentificationVisitor;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.Nullable;

public class ArtifactPathsCollector
extends ModuleIdentificationVisitor {
    private final StringBuilder builder = new StringBuilder();
    private final String separator;
    private final String prefix;

    public ArtifactPathsCollector(ObjectFactory objectFactory, String separator, String prefix) {
        super(objectFactory);
        this.separator = separator;
        this.prefix = prefix;
    }

    protected void visitModule(File file, String group, String module, String version, @Nullable String classifier, String extension) throws Exception {
        this.builder.append(this.prefix);
        this.builder.append(group.replace(".", "/"));
        this.builder.append("/");
        this.builder.append(module);
        this.builder.append("/");
        this.builder.append(version);
        this.builder.append("/");
        this.builder.append(module);
        this.builder.append("-");
        this.builder.append(version);
        if (classifier != null && !classifier.isEmpty()) {
            this.builder.append("-");
            this.builder.append(classifier);
        }
        this.builder.append(".").append(extension);
        this.builder.append(this.separator);
    }

    public String toString() {
        String result = this.builder.toString();
        if (result.endsWith(this.separator)) {
            return result.substring(0, result.length() - this.separator.length());
        }
        return result;
    }
}

