/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.util.FilteringZipBuildingFileTreeVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class StripBinPatchedClasses
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    @TaskAction
    public void doTask() throws Exception {
        final HashSet cleanedFiles = new HashSet();
        final HashSet cleanedDirectories = new HashSet();
        this.getArchiveOperations().zipTree((Object)((RegularFile)this.getClean().get()).getAsFile()).visit(new FileVisitor(){

            public void visitDir(@NotNull FileVisitDetails dirDetails) {
                cleanedDirectories.add(dirDetails.getRelativePath().getPathString());
            }

            public void visitFile(@NotNull FileVisitDetails fileDetails) {
                cleanedFiles.add(fileDetails.getRelativePath().getPathString());
            }
        });
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        try (FileOutputStream outputStream = new FileOutputStream(output);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            FilteringZipBuildingFileTreeVisitor visitor = new FilteringZipBuildingFileTreeVisitor(zipOutputStream, details -> !cleanedDirectories.contains(details.getRelativePath().getPathString()), details -> !cleanedFiles.contains(details.getRelativePath().getPathString().contains("$") ? details.getRelativePath().getPathString().substring(0, details.getRelativePath().getPathString().indexOf("$")) + ".class" : details.getRelativePath().getPathString()));
            this.getArchiveOperations().zipTree((Object)((RegularFile)this.getCompiled().get()).getAsFile()).getAsFileTree().visit((FileVisitor)visitor);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getClean();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getCompiled();
}

