/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.srgutils.IMappingBuilder;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class OfficialMappingsJustParameters
extends DefaultRuntime
implements WithOutput {
    @Inject
    public OfficialMappingsJustParameters() {
        this.getOutputFileName().set((Object)"output.tsrg");
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @TaskAction
    void exec() throws IOException {
        IMappingFile source = IMappingFile.load((File)((File)this.getInput().getAsFile().get()));
        IMappingBuilder builder = IMappingBuilder.create((String[])new String[0]);
        source.getClasses().forEach(cls -> {
            IMappingBuilder.IClass c = builder.addClass(new String[]{cls.getMapped(), cls.getMapped()});
            cls.getMethods().forEach(mtd -> {
                if (mtd.getParameters().isEmpty()) {
                    return;
                }
                IMappingBuilder.IMethod m = c.method(mtd.getMappedDescriptor(), new String[]{mtd.getMapped(), mtd.getMapped()});
                mtd.getParameters().forEach(par -> m.parameter(par.getIndex(), new String[]{par.getOriginal(), par.getMapped()}));
            });
        });
        builder.build().write(((RegularFile)this.getOutput().get()).getAsFile().toPath(), IMappingFile.Format.TSRG2);
    }
}

