/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.tasks;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.platform.tasks.TokenizedTask;
import net.neoforged.gradle.platform.util.ArtifactPathsCollector;
import net.neoforged.gradle.platform.util.StringUtils;
import org.apache.tools.ant.filters.ReplaceTokens;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class CreateClasspathFiles
extends DefaultRuntime
implements TokenizedTask {
    public CreateClasspathFiles() {
        this.getTemplate().set(this.getProject().getRootProject().file((Object)"server_files/args.txt"));
        this.getOutputFileName().convention((Object)"args.txt");
    }

    @TaskAction
    public void doTask() throws Exception {
        HashMap<String, Object> tokens = new HashMap<String, Object>((Map)this.getTokens().get());
        ArtifactPathsCollector modulePathCollector = new ArtifactPathsCollector(this.getObjectFactory(), (String)this.getPathSeparator().get(), "libraries/");
        ArtifactPathsCollector classpathCollector = new ArtifactPathsCollector(this.getObjectFactory(), (String)this.getPathSeparator().get(), "libraries/");
        this.getModulePath().getAsFileTree().visit((FileVisitor)modulePathCollector);
        this.getClasspath().getAsFileTree().visit((FileVisitor)classpathCollector);
        tokens.put("MODULE_PATH", modulePathCollector.toString());
        String externalClassPath = classpathCollector + (String)this.getPathSeparator().get() + String.format("libraries/net/minecraft/server/%s/server-%s-extra.jar", this.getNeoFormVersion().get(), this.getNeoFormVersion().get());
        Set claimedCoordinateLikePath = Arrays.stream(externalClassPath.split((String)this.getPathSeparator().get())).map(path -> StringUtils.getSlicedPrefixSection(path, "/", 2)).collect(Collectors.toSet());
        FileTree serverRawTree = this.getArchiveOperations().zipTree(this.getServer().get());
        File joinedServerClasspathFile = serverRawTree.filter(spec -> spec.getPath().endsWith("META-INF" + File.separator + "classpath-joined")).getSingleFile();
        String joinedServerClasspath = Files.readAllLines(joinedServerClasspathFile.toPath()).stream().flatMap(line -> Arrays.stream(line.split(";"))).filter(path -> !claimedCoordinateLikePath.contains(StringUtils.getSlicedPrefixSection(path, "/", 2))).filter(path -> path.startsWith("libraries/")).collect(Collectors.joining((CharSequence)this.getPathSeparator().get()));
        String classpath = externalClassPath + (String)this.getPathSeparator().get() + joinedServerClasspath;
        tokens.put("CLASS_PATH", classpath);
        this.getFileSystemOperations().copy(copySpec -> {
            copySpec.from((Object)((RegularFile)this.getTemplate().get()).getAsFile(), spec -> {
                spec.rename(name -> (String)this.getOutputFileName().get());
                spec.filter((Map)ImmutableMap.of((Object)"tokens", (Object)tokens), ReplaceTokens.class);
            });
            copySpec.into((Object)((Directory)this.getOutputDirectory().get()).getAsFile());
        });
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getTemplate();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getModulePath();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getClasspath();

    @Input
    public abstract Property<String> getPathSeparator();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServer();

    @Input
    public abstract Property<String> getNeoFormVersion();
}

