/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.tasks;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.DiffOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import java.nio.file.Path;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateSourcePatches
extends DefaultRuntime
implements WithOutput,
WithWorkspace {
    public GenerateSourcePatches() {
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
        this.getLineEnding().convention((Object)"\n");
        this.getShouldOutputVerboseLogging().convention((Object)false);
        this.getContextLines().convention((Object)-1);
        this.getShouldCreateAutomaticHeader().convention((Object)true);
        this.getShouldPrintSummary().convention((Object)false);
    }

    @TaskAction
    public void doTask() throws Exception {
        Path base = ((RegularFile)this.getBase().get()).getAsFile().toPath();
        Path modified = ((RegularFile)this.getModified().get()).getAsFile().toPath();
        Path output = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
        this.getLogger().info("Base: {}", (Object)base);
        this.getLogger().info("Modified: {}", (Object)modified);
        DiffOperation.Builder builder = DiffOperation.builder().logTo(arg_0 -> ((Logger)this.getLogger()).lifecycle(arg_0)).baseInput((Input)Input.MultiInput.detectedArchive((Path)base)).changedInput((Input)Input.MultiInput.detectedArchive((Path)modified)).patchesOutput((Output)Output.MultiOutput.detectedArchive((Path)output)).autoHeader(((Boolean)this.getShouldCreateAutomaticHeader().get()).booleanValue()).level((Boolean)this.getShouldOutputVerboseLogging().get() != false ? LogLevel.ALL : LogLevel.WARN).summary(((Boolean)this.getShouldPrintSummary().get()).booleanValue()).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).lineEnding((String)this.getLineEnding().get());
        if ((Integer)this.getContextLines().get() != -1) {
            builder.context(((Integer)this.getContextLines().get()).intValue());
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
    }

    @InputFile
    public abstract RegularFileProperty getBase();

    @InputFile
    public abstract RegularFileProperty getModified();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @org.gradle.api.tasks.Input
    public abstract Property<String> getLineEnding();

    @org.gradle.api.tasks.Input
    public abstract Property<Boolean> getShouldCreateAutomaticHeader();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Integer> getContextLines();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Boolean> getShouldOutputVerboseLogging();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Boolean> getShouldPrintSummary();
}

