/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.platform.runtime.runtime.tasks;

import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.nio.file.Path;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class ApplyPatches
extends DefaultRuntime
implements WithWorkspace,
WithOutput {
    public ApplyPatches() {
        this.getPatchesPrefix().convention((Object)"");
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
        this.getShouldFailOnPatchFailure().convention((Object)false);
        this.getPatchMode().convention(this.getShouldFailOnPatchFailure().map(fail -> fail != false ? PatchMode.ACCESS : PatchMode.FUZZY));
        this.getMinimalFuzzingQuality().convention((Object)Float.valueOf(0.9f));
    }

    @TaskAction
    public void doTask() throws Exception {
        if (!this.getPatches().isPresent()) {
            FileUtils.copyFile((File)((File)this.getBase().getAsFile().get()), (File)((RegularFile)this.getOutput().get()).getAsFile());
            return;
        }
        Path outputPath = this.ensureFileWorkspaceReady(this.getOutput()).toPath();
        Directory rejectsDir = (Directory)this.getRejects().get();
        Path rejectsPath = rejectsDir.getAsFile().toPath();
        PatchOperation.Builder builder = PatchOperation.builder().logTo(arg_0 -> ((Logger)this.getLogger()).lifecycle(arg_0)).baseInput((Input)Input.MultiInput.detectedArchive((Path)((RegularFile)this.getBase().get()).getAsFile().toPath())).patchesInput((Input)Input.MultiInput.folder((Path)((Directory)this.getPatches().get()).getAsFile().toPath())).patchedOutput((Output)Output.MultiOutput.detectedArchive((Path)outputPath)).rejectsOutput((Output)Output.MultiOutput.folder((Path)rejectsPath)).mode((PatchMode)this.getPatchMode().get()).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).level((Boolean)this.getShouldFailOnPatchFailure().get() != false ? LogLevel.WARN : LogLevel.ALL).patchesPrefix((String)this.getPatchesPrefix().get());
        builder.minFuzz(((Float)this.getMinimalFuzzingQuality().get()).floatValue());
        if (this.getMaximalFuzzingOffset().isPresent()) {
            builder.maxOffset(((Integer)this.getMaximalFuzzingOffset().get()).intValue());
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
        if (exit != 0 && ((Boolean)this.getShouldFailOnPatchFailure().get()).booleanValue()) {
            throw new RuntimeException("Patches failed to apply.");
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getBase();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getPatches();

    @OutputDirectory
    @Optional
    public abstract DirectoryProperty getRejects();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<ArchiveFormat> getRejectsFormat();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<PatchMode> getPatchMode();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getPatchesPrefix();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Float> getMinimalFuzzingQuality();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Integer> getMaximalFuzzingOffset();

    @org.gradle.api.tasks.Input
    @Optional
    public abstract Property<Boolean> getShouldFailOnPatchFailure();
}

